/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002-2004 by Hokkaido Industrial Research Institute, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: sh7615frt.h,v 1.1 2008/06/17 00:04:40 suikan Exp $
 */

/*
 *	^C}hCo
 *  FRTgp
 */

#ifndef _SH7615FRT_H_
#define _SH7615FRT_H_

/*
 *   ^C}ւ̓̓NbN̕ݒ
 *   	f/8ŃJEg
 */
#define TCR_CKS         0x0

/*
 *   ^C}ɋNbNg[kHz]
 *   	14.7456MHz/8 =1.8432MHz =1843.2kHz
 */
#define TIMER_CLOCK	1843


/*
 *  ^C}l̓\̌^
 */
typedef UH CLOCK;

/*
 *  ^C}l̓\ƃ~bEʕbPʂƂ̕ϊ
 *
 */
#define	TO_CLOCK(nume, deno)	(TIMER_CLOCK * (nume) / (deno))
#define	TO_USEC(clock)		((clock) * 1000 / TIMER_CLOCK)
#define CLOCK_PER_TICK	((CLOCK) TO_CLOCK(TIC_NUME, TIC_DENO))

/*
 *  ݒłő̃^C}iPʂ͓\j
 */
#define	MAX_CLOCK	((CLOCK) 0xffff)

/*
 *  ^C}̌ݒlݔO̒lƂ݂Ȃ̔f
 */
#define	GET_TOLERANCE	100		/* x̌ςliPʂ͓\j */
#define	BEFORE_IREQ(clock) \
		((clock) >= TO_CLOCK(TIC_NUME, TIC_DENO) - GET_TOLERANCE)

/*
 *  Rg[WX^̃AhX
 */

#define FRT_FTCSR	(VB *)0xfffffe11
#define FRT_TOCR	(VB *)0xfffffe17
#define FRT_TCR		(VB *)0xfffffe16
#define FRT_OCRH	(VB *)0xfffffe14
#define FRT_OCRL	(VB *)0xfffffe15
#define FRT_TIER	(VB *)0xfffffe10
#define FRT_FRCH	(VB *)0xfffffe12
#define FRT_FRCL	(VB *)0xfffffe13


#ifndef _MACRO_ONLY

/*
 *  ^C}X^[g
 */
Inline void
sh2_timer_start ()
{
	/* OCRAvɂ銄 */
	sil_wrb_mem (FRT_TIER, sil_reb_mem(FRT_TIER) | 0x08);
}

/*
 *  ^C}ꎞ~
 */
Inline void
sh2_timer_stop ()
{
	/* OCRAvɂ銄s */
	sil_wrb_mem (FRT_TIER, sil_reb_mem(FRT_TIER) & ~0x08);
}
/*
 *  ^C}ݗṽNA
 *	TCRWX^IMFArbg1ǂݏoɂO
 */
Inline void
sh2_timer_int_clear ()
{
	/* 荞ݗvNA     */
	/*  iGRARyA}b`tOj */
	sil_wrb_mem (FRT_FTCSR, sil_reb_mem (FRT_FTCSR) & 0xf7);
	/* OCRARyA}b`tÕNA */

}


/*
 *  ^C}̋N
 *
 *  ^C}CIȃ^C}ݗv𔭐D
 */
Inline void
sh2_timer_initialize ()
{
	CLOCK cyc = TO_CLOCK (TIC_NUME, TIC_DENO);


	/*
	 *  ^C}֘A̐ݒ
	 */
	sh2_timer_stop ();			/* ^C}~ */
	/* ^C}l̃`FbN */
	assert (cyc <= MAX_CLOCK);

	/* OCRAI */
	sil_wrb_mem (FRT_TOCR, 0x00);
	/*  ݒ  clock 1/8   */
	sil_wrb_mem (FRT_TCR, 0x00);
	/* OCRAvɂFRC̃NA */
	sil_wrb_mem (FRT_FTCSR, sil_reb_mem (FRT_FTCSR) | 0x01);
	/* RyA}b`tÕNA */
	sil_wrb_mem (FRT_FTCSR, sil_reb_mem (FRT_FTCSR) & 0xf7);
	/*  OCRAWX^ݒiJE^ڕWlj      */
	sil_wrb_mem (FRT_OCRH, (CLOCK_PER_TICK >> 8) & 0x00ff);
	sil_wrb_mem (FRT_OCRL, (CLOCK_PER_TICK) & 0x00ff);
	/* OCRAvɂ銄 */
	sil_wrb_mem (FRT_TIER, 0x09);
	/* JE^NA             */
	sil_wrb_mem (FRT_FRCH, 0);
	sil_wrb_mem (FRT_FRCL, 0);
}

/*
 *  ^C}̒~
 *
 *  ^C}̓~D
 */
Inline void
sh2_timer_terminate ()
{
	sh2_timer_stop ();			/* ^C}~     */
	sh2_timer_int_clear ();		/* 荞ݗvNA */

	sil_wrb_mem (FRT_TIER, 0x01);	//荞ݕs
	sil_wrb_mem (FRT_FRCH, 0);
	sil_wrb_mem (FRT_FRCL, 0);
	sil_wrb_mem (FRT_OCRH, 0);
	sil_wrb_mem (FRT_OCRL, 0);
}

/*
 *  ^C}̌ݒl̓Ǐo
 *@@@^C}lǂݏoD
 */
Inline CLOCK
sh2_timer_get_current ()
{
	CLOCK	clk;
	CLOCK up, low;


	up = sil_reb_mem (FRT_FRCH);
	low = sil_reb_mem (FRT_FRCL);
	clk = (up << 8) | low;
	return (clk);
}

/*
 *  ^C}ݗṽ`FbN
 */
Inline BOOL
sh2_timer_fetch_interrupt ()
{
	return (sil_reb_mem (FRT_FTCSR) & 0x08);
}

#endif /* _MACRO_ONLY */
#endif /* _SH7615FRT_H_ */
