/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: hw_serial.h,v 1.1 2008/06/17 00:04:40 suikan Exp $
 */

/*
 *  VAI/OfoCXiSIOjhCoiMS7717CP01pj
 *  
 */

#ifndef _HW_SERIAL_H_
#define _HW_SERIAL_H_

#include <s_services.h>

#include <sh3.h>
#include <ms7727cp01.h>
#include <st16c2550.h>

/*
 *  VÅ݃nh̃xN^ԍ(ݗDx)
 */
#define INHNO_SIO   ST16C2550_INT

/*
 * 荞݃x
 */
#define SIO_INTLVL   8

/*
 *  SIOhCȍ[`
 */
#define sio_initialize  st16c2550_initialize

#ifndef _MACRO_ONLY
/*
 *  VAI/O|[g̃I[v
 */
Inline SIOPCB *
sio_opn_por(ID siopid, VP_INT exinf)
{
    SIOPCB  *siopcb;
    BOOL    openflag;

    /*
     *  I[v|[g邩 openflg ɓǂłD
     */
    openflag = st16c2550_openflag();
    
    /*
     *  foCXˑ̃I[vD
     */
    siopcb = st16c2550_opn_por(siopid, exinf);

    /*
     * 荞݊֘A̐ݒ
     * G[nho^ׂ
     */
    if(!openflag){
        define_int_plevel(INHNO_SIO,SIO_INTLVL);     /* SWDx */
        sil_wrh_mem((VP)IPRD,                        /* HWDx */  
                    (sil_reh_mem((VP)IPRD) | (SIO_INTLVL << 12))); 
        /* PINTCl[u */
        sil_wrh_mem((VP)PINTER,
                    (sil_reh_mem((VP)PINTER) | siopcb->siopinib->pinter_val));
    }

    return(siopcb);
}

/*
 *  VAI/O|[g̃N[Y
 */
Inline void
sio_cls_por(SIOPCB *siopcb)
{
    /*
     *  foCXˑ̃N[YD
     */
    st16c2550_cls_por(siopcb);
}


/*
 *  SIO̊݃nh
 */
#define sio_handler st16c2550_isr

/*
 *  VAI/O|[gւ̕M
 */
#define sio_snd_chr st16c2550_snd_chr

/*
 *  VAI/O|[g̕M
 */
#define sio_rcv_chr st16c2550_rcv_chr

/*
 *  VAI/O|[g̃R[obN̋
 */
#define sio_ena_cbr st16c2550_ena_cbr

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
#define sio_dis_cbr st16c2550_dis_cbr

/*
 *  VAI/O|[g̑M\R[obN
 */
#define sio_ierdy_snd   st16c2550_ierdy_snd

/*
 *  VAI/O|[g̎MʒmR[obN
 */
#define sio_ierdy_rcv   st16c2550_ierdy_rcv

#endif /* _MACRO_ONLY */
#endif /* _HW_SERIAL_H_ */
