/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: sys_defs.h,v 1.1 2008/06/17 00:04:40 suikan Exp $
 */

/*
 *  ^[QbgVXeɈˑ`iMS7717CP01pj
 *
 *  ̃CN[ht@ĆCkernel.h  sil.h ŃCN[hD
 *  ̃t@C璼ڃCN[h邱Ƃ͂ȂD̃t@CC
 *  N[hOɁCt_stddef.h  itron.h CN[ĥŁC
 *  ɈˑĂ悢D
 */

/*
 *  VXeɈˑ`
 */

#ifndef _SYS_DEFS_H_
#define _SYS_DEFS_H_

/*
 *  NbZ[W̃^[Qbg
 */
#define	TARGET_NAME	"MS7727CP01(SH7727 T-Engine)"

/*
 * vZbT̎(DSPɂ͑ΉĂȂ)
 */
#define SH3
#define SH7727

/*
 *  vZbT̃GfBA
 */
#define SIL_ENDIAN  SIL_ENDIAN_LITTLE  /* gGfBA */


/*
 *  JSPJ[l쎞̃}bv
 *      0x8c000000 - 0x8c000000 xN^e[u
 *      0x8c000500 - 0x8c001fff T-Monitorgp̈
 *      0x8c002000 - 0x8cffffff R[ḧ(1MB)
 *      0x8c100000 -            f[^̈(3MB)
 *                 - 0x8c3fffff ^XNƗpX^bN
 *                 - 0x8e000000 I
 *
 */

/*
 *   X^bN̈̒`
 */
#define STACKTOP    0x8c400000    /* ^XNƗpX^bN̏l */

/*
 *  ^CeBbN̒`
 */
#define	TIC_NUME	1		/* ^CeBbN̎̕q */
#define	TIC_DENO	1		/* ^CeBbN̎̕ */

/*
 *  ^C}[̊荞݃x
 */
#define KTIM_INT_LV   4

/*
 *  ^C}l̓\ msec PʂƂ̕ϊ
 *  MS7727CP01ł́APNbN24MHz
 *   /4,/16,/64/256 ̂ꂩI
 *  /4:  6Mhz     tick 6000   0.16 sec
 *  /16: 1.5Mhz   tick 1500   0.6 sec
 *  /64: 0.375Mhz tick 375    2.6 sec
 *  /256:0.097Mhz tick 97     10 sec
 *
 *  /16 I
 *  TMŨNbN̏2Mhz
 */

#define TCR0_TPSC  0x0001


/*
 *  ^C}l̓\ƃ~bPʂƂ̕ϊ
 */
#define TIMER_CLOCK     1600

/*
 *  ԑ҂̂߂̒`
 */
#define	SIL_DLY_TIM1	 90
#define	SIL_DLY_TIM2	 50


#ifndef _MACRO_ONLY


Inline void
kernel_abort()
{
    UW sr = 0x10000000;
    
    /*
     * IɃZbg𔭐
     */
    /*
     * BLrbg𗧂Ă
     */
	Asm("ldc %0, sr" : : "r"(sr) );
    
    /*
     * ݗO
     */
    *((volatile int *) 0xFFFFFEC1) = 0;
}
#endif /* _MACRO_ONLY */


#endif /* _SYS_DEFS_H_ */













