/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: debugout.c,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */

#include <debugout.h>
#include <hal_msg.h>
#include <resource.h>

#ifdef DEBUG_ENABLE

#define DBG_SIZE_STRINGBUFFER 512

static HANDLE DebugConsole;     //fobO\eLXg{bNX
static HWND   DialogHandle;     //fobOo̓_CAO

extern void FatalAssertion(int exp, LPCSTR format, ... );

/*
 * fobOp_CAÕbZ[Wnh
 */
static LRESULT CALLBACK DebugOutDialogProc(HWND hDlg,UINT Msg,WPARAM wParam,LPARAM lParam)
{
	switch(Msg)
	{
	case WM_INITDIALOG:
		DebugConsole = GetDlgItem(hDlg,IDC_DEBUGOUT);       //o͐eLXg{bNX
		ShowWindow(hDlg,SW_SHOW);

	case WM_SIZE:
		{
			RECT client;
			GetClientRect(hDlg,&client);
			MoveWindow(DebugConsole,0,0,client.right,client.bottom,TRUE);
			break;
		}

	case WM_CLOSE:
			/* Never let this dialog close by pressing of the close button. */
		break;

	case WM_DESTROY:
		DialogHandle = 0;
		break;

	case WM_QUIT:
		DestroyWindow(hDlg);
		break;
	
	default:
		return FALSE;
	}
	return TRUE;
}

    /* 2֐肷邽߂̍\ */
struct tagInitializeDebugServicesParam {
    HINSTANCE hInstance;
    HWND      hDlg;
};

    /* fobO[`Ƃ߂ */
void FinalizeDebugServices(void)
{
    if(DialogHandle != 0l) {
		DestroyWindow(DialogHandle);
    }
}

    /* ǗXbhsEBhE쐬[` */
static void _initializeDebugServices(void * _param)
{
    struct tagInitializeDebugServicesParam * param = (struct tagInitializeDebugServicesParam *)_param;
    DialogHandle = CreateDialog(param->hInstance, MAKEINTRESOURCE(DEBUGOUTDIALOG), param->hDlg, DebugOutDialogProc);
    FatalAssertion(DialogHandle != NULL, "DebugService could not create its own dialog.");     
}

    /* fobO[`̏ iǗXbhɃ_CAOĂ炤) */
void InitializeDebugServices(HINSTANCE hinst,HWND dlg)
{
    struct tagInitializeDebugServicesParam param;
    param.hInstance = hinst;
    param.hDlg      = dlg;

    HALExecuteProcedure(_initializeDebugServices, (void *)&param);      //˗
    HALAddDestructionProcedure(FinalizeDebugServices, 0);               //j[`̓o^
}

    /* fobOpprintf */
int _debugOut(const char * format, ... )
{
	int result;
	int i;
	char buffer[DBG_SIZE_STRINGBUFFER*2];
	char * scope;
	const char * work;
	va_list vl;

	if(format == 0l)
		return 0;

	va_start(vl, format);

		/* formatɊ܂܂ '\n'  '\r\n' ɒu */
	scope = buffer;
	work  = format;

	while(*format != '\0')
	{
		if(*format == '\n')
		{
			i = format - work;
			lstrcpyn(scope, work, i);
			
			scope += i;
			work = format;

			*(scope++) = '\r';
		}
		format ++;
	}

	i = format - work + 1;
	lstrcpyn(scope, work, i);		//+1'\x0'Rs[
	scope += i;

	if((result = wvsprintf(scope, buffer, vl)) > 0)
	{
			//o͂班Jbg
		i = GetWindowTextLength(DebugConsole);
		if(i > DEBUG_LIMITTERUPPERBOUND)
		{
			SendMessage(DebugConsole, EM_SETSEL, 0, i - DEBUG_LIMITTERUPPERBOUND);
			SendMessage(DebugConsole, EM_REPLACESEL, (WPARAM)FALSE, (LPARAM)"");
		}

		SendMessage(DebugConsole,EM_SETSEL,i,i);
		SendMessage(DebugConsole,EM_REPLACESEL,(WPARAM)FALSE,(LPARAM)scope);
	}

	return result;
}

#endif


