/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: eventlog.h,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */


#ifndef __EVENTLOG_H__
#define __EVENTLOG_H__

#include <constants.h>

#include <stdarg.h>
#include "syslog.h"

	/*
	 *  ITRONfobMOC^tF[X֘A̒`
	 */

	/*
	 *  fBXpb`
	 */
#define DSP_NORMAL		0;	//^XNReLXg̃fBXpb`
#define DSP_NONTSKCTX	1;	//ݏCPUÕfBXpb` 

	typedef	W		BITMASK;
	typedef UINT	INHNO;

	/* ݃nh */
	typedef struct t_rglog_interrupt{
		INHNO	inhno;	//݃nhԍ
	} T_RGLOG_INTERRUPT;

	/* ݃T[rXnh(gp) */
	typedef struct t_rglog_isr {
		ID		isrid;	//݃T[rX[`ID
		INHNO	inhno;	//݃nhԍ
	} T_RGLOG_ISR;

	/* ^CCxgnh */
	typedef struct t_rglog_timerhdr {
		UINT	type;	//^C}[̎
		ID		hdrid;	//^CCxgnhID
		VP_INT	exinf;	//g
	} T_RGLOG_TIMERHDR;

	/* CPUOnh */
	typedef struct t_rglog_cupexc {
		ID		tskid;	//ΏۂƂȂ^XNID
	} T_RGLOG_CPUEXC;

	/* ^XNO[` */
	typedef struct t_rglog_tskexc {
		ID		tskid;	//ΏۂƂȂ^XNID
	} T_RGLOG_TSKEXC;

	/* ^XNԕω */
	typedef struct t_rglog_tskstat {
		ID		tskid;		//^XNID
		STAT	tskstat;	//Jڐ^XN
		STAT	tskwait;	//҂
		ID		wobjid;		//҂Ώۂ̃IuWFNgID
	} T_RGLOG_TSKSTAT;

	/* fBXpb`Jn */
	typedef struct t_rglog_dispatch_enter {
		ID		tskid;		//^XNID
		UINT	disptype;	//fBXpb`
	} T_RGLOG_DISPATCH_ENTER;

	/* fBXpb`I */
	typedef struct t_rglog_dispatch_leave {
		ID		tskid;		//^XNID
	} T_RGLOG_DISPATCH_LEAVE;

	/* T[rXR[ */
	typedef struct t_rglog_svc {
		FN		fncno;		//@\R[h
		UINT	prmcnt;		//p[^
		VP_INT	prmary[1];	//p[^
	} T_RGLOG_SVC;

	/* Rgî݂̃Oj */
	typedef struct t_rglog_comment {
		UINT	length;		//̒
		char	strtext[1];	//(NULLI[)-f
	} T_RGLOG_COMMENT;

	typedef struct t_rglog_header {
		UINT	logtype;
		SYSTIM	logtim;
		BITMASK	valid;
		UINT	bufsz;
	} T_RGLOG_HEADER;

	typedef union t_rglog_body
	{
		T_RGLOG_INTERRUPT		interrupt;
		T_RGLOG_ISR				isr;
		T_RGLOG_TIMERHDR		timerhdr;
		T_RGLOG_CPUEXC			cpuexc;
		T_RGLOG_TSKEXC			tskexc;
		T_RGLOG_TSKSTAT			tskstat;
		T_RGLOG_DISPATCH_ENTER	dispatch_enter;
		T_RGLOG_DISPATCH_LEAVE	dispatch_leave;
		T_RGLOG_SVC				svc;
		T_RGLOG_COMMENT			comment;
	} T_RGLOG_BODY;

	typedef struct DBIFLOG
	{
		struct	t_rglog_header	header;
		union	t_rglog_body	body;
	} DBIFLOG;

	typedef struct t_rglog
	{
		UINT	logtype;
		SYSTIM	logtim;
		BITMASK	valid;
		UINT	bufsz;
		char	buf[1];
	} T_RGLOG;

#ifdef EVENTLOG_ENABLE
#ifdef __cplusplus
#define EXTERN extern "C"
#else
#define EXTERN extern
#endif

		EXTERN void event_write_syslog(const SYSLOG * str);
		EXTERN void event_write(unsigned int logtype, unsigned int valid, UINT bufsz, ... );
		EXTERN void event_write_svc_enter(int fncd, unsigned int params, ... );
		EXTERN void event_write_svc_leave(int fncd, unsigned int ercd, unsigned int retaddr);
		EXTERN void event_write_wait_unknown(int tskid);

#undef EXTERN

#endif //EVENTLOG_ENABLE

#endif //__EVENTLOG_H__

