/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2005 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

/*
 *  EVAfobKp@픻ʏ
 *  (section0x7f00-0x7fffɃN)
 */

#define CHIP_NAME "LC59_32K"
#define RAM_SIZE 0x7E00
#define ROM_SIZE 0x78000
#define VRAM_SIZE 0x0000
#define VRAM_ROW 0
#define VRAM_COLUMN 0
#define CGROM_SIZE 0x0000
#define BCD(x)  (((x)/10)%10)*0x10+((x)%10)
#define BCD4(x) BCD((x)/100),BCD(x)
#define BCD6(x) BCD((x)/10000),BCD((x)/100),BCD(x)

        .section .chip_info,"a"
        .global _chip_info
_chip_info:
        .space  0xc0,0x00
        .ascii  "CHIPINFORMATION"               /* C0-CF : fixed string */
1:      .space  (0xd0-1b),0x00
        .ascii  CHIP_NAME                       /* D0-DF : chip name */
2:      .space  (0xe0-2b),0x00
        .byte   0x10, 0x00                      /* E0-E1 : format version */
        .space  6, 0x00
        .byte   BCD4(ROM_SIZE/1024)             /* E8-F5 : Memory sizes */
        .byte   BCD6(RAM_SIZE)
        .byte   BCD6(VRAM_SIZE)
        .byte   BCD4(VRAM_ROW)
        .byte   BCD4(VRAM_COLUMN)
        .byte   BCD4(CGROM_SIZE/1024)
        .space  3, 0x00
        .byte   0x01                            /* F9 : package type */
        .space  6, 0x00

        .end
