//
//  ECLayer.h
//  Etokicho
//
//  Created by 二鏡 on 11/11/27.
//  Copyright 2011年 二鏡庵. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class ECScene;
// 基本属性
extern NSString *plistLayerTypeKey; // レイヤーのタイプ。これがクラスと結びつく
extern NSString *plistLayerAuxResourceNameKey; // 外部ファイル名を記憶するキー
extern NSString *plistLayerOriginKey; // origin
extern NSString *plistLayerSizeKey;   // size
extern NSString *plistLayerHideKey;   // hide
extern NSString *plistLayerLockKey;   // lock
extern NSString *plistLayerNameKey;   // name
extern NSString *plistLayerAlphaKey;  // alpha

static inline NSURL*
_layerResourceURLForName(NSURL* packageURL, NSString *filename)
{
    id path = [NSString stringWithFormat: @"resources/%@", filename];
    id URL = [packageURL URLByAppendingPathComponent: path];
    return URL;
}

// 基本的にsceneはcodingされないので、ペースト後に正しく挿入されなければならない
@interface ECLayer : NSObject <NSCoding,NSCopying>
{
    ECScene *scene;
    NSString *name;
    CGPoint origin;
    CGSize size;
    CGFloat alpha;
}

@property (readwrite,assign) ECScene *scene; // owner
// 基本属性
@property (nonatomic,readwrite,assign) CGPoint origin;
@property (nonatomic,readwrite,assign) CGSize size;
@property (nonatomic,readwrite,assign) CGFloat alpha;
// シーン全体の大きさ。
// sub geometry
@property (readonly) CGRect bounds;
@property (readonly) CGPoint center;

// これらはprivate
@property (readwrite) BOOL lock;
// 編集用のロックフラグ
// 移動や変形に対して抵抗する

@property (readwrite) BOOL hide;
// hideフラグが立つと完全に無効化される
// 動画にも反映されず、表示も編集もされない

@property (readwrite,copy) NSString *name;
// レイヤの管理名
// クリアする場合nilではなく@""をつかうこと

// レイヤークラスを登録
+ (void)registerClass:(Class)layerClass;
// type keyをみてregisterされたクラスからアロケーションをかける
// 知らない場合はnil
+ (id)layerWithPropertyList:(NSDictionary*)plist
                 packageURL:(NSURL*)aURL;

// TO OVERRIDE
// デフォルト実装は基本属性を保存/解析する
+ (NSString*)type; // レイヤタイプ宣言。
- (id)initWithPropertyList:(NSDictionary*)plist
                packageURL:(NSURL*)aURL;
- (NSURL*)auxResourceURL; // リソースがない場合はnilを返す(デフォルト)
- (id)propertyListWithAuxResourceName:(NSString*)filename; // リソースがない場合はnilがくる
+ (id)undoObservationKeys; // Sketch 10.6方式に移行だぜ！

// シーンが時間変動しない時はYES
- (BOOL)isStatic;
// 時間変動イメージを出力。静的でないフレームはレンダリング時にこちらをつかう
- (void)renderAtTime:(NSUInteger)msec
           inContext:(CGContextRef)context;    
// 静的ポスターイメージを出力
- (void)renderInContext:(CGContextRef)context; 
- (void)renderThumbnailInContext:(CGContextRef)context;
- (void)cleanupRendering;  // レンダリングが終了した時に一時リソースの解放を行う

// サービスメソッド
- (BOOL)pointInRect:(CGPoint)aPoint;
- (void)drawFrameWithColor:(NSColor*)aColor; 
// フレーム領域を覆う枠を描画する
// NSView上以外では使わない

@end
