//
//  ECSceneComposition.h
//  Etokicho
//
//  Created by 二鏡 on 11/12/02.
//  Copyright 2011年 二鏡庵. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "ECScene.h"
#import "ECLayerProxy.h"

// 編集中のシーンのオーナー
// 編集プロキシでもある
@interface ECSceneComposition : NSObject
{
    NSUndoManager *undo;
    ECScene *scene;
    NSIndexSet *selection;
    ECLayerProxy *selectedLayer;
}
@property (readonly) NSUndoManager *undo;
@property (nonatomic,retain) ECScene *scene;
@property (nonatomic,copy) NSIndexSet *selection;
@property (readonly) ECLayerProxy *selectedLayer;
@property (readonly) BOOL update;

// for up/down
- (void)exchangeLayersAtIndex:(NSUInteger)oldIndex
                         with:(NSUInteger)newIndex;
- (void)add:(ECLayer*)layer; // at top
- (void)select:(ECLayer*)aLayer;
- (void)deselect;

- (void)up;
- (void)down;
- (void)insertRegular;
- (void)insertAnimation;
- (void)remove;

- (BOOL)canUp;
- (BOOL)canDown;
- (BOOL)canDelete;

- (void)clear;
@end
