<?php
     class SmartMan{

          protected $_dirPath;

          public function __construct($dir_path)
          {
               $this->_dirPath = $dir_path;
          }

          private function _autoMKDirByFileDate($full_path_file)
          {
               $create_date = $this->_getFileCrateDate($full_path_file);

               $dir_per_day = $this->_dirPath.'/'.$create_date;
               if (!is_dir($dir_per_day)){
                    mkdir($dir_per_day);
               }
               return $dir_per_day;
          }

          public function autoFile2DayDir()
          {
               $filelist = $this->_getFileList();
               foreach ($filelist as $filename) {
				    //echo $filename.'<hr/>';
                    $full_path_file = $this->_dirPath.'/'.$filename;
                    if(is_file($full_path_file))
                    {
						 echo $full_path_file.'<br/>';
                         $dir_per_day = $this->_autoMKDirByFileDate($full_path_file);
                         echo $dir_per_day.'<br/>';
                         if (!rename($full_path_file,$dir_per_day.'/'.$filename))
                         {
                              echo $full_path_file.' move to '.$dir_per_day.'/'.$filename.' failure<br/>';
                         }else{
							 echo $full_path_file.' move to '.$dir_per_day.'/'.$filename.' successfully <br/>';
						 }
                    }
               }
          }

          private function _getFileList()
          {
               if (is_dir($this->_dirPath))
               {
                    return scandir($this->_dirPath);
               }
          }

          private function _getFileCrateDate($file)
          {
               $exif = @read_exif_data($file);
               if (is_array($exif)){ // process image file
                    while(list($k,$v)=each($exif))
                    {
                         //echo "$k: $v<br>";

                         if ($k == 'DateTimeOriginal')
                         {
                              return str_replace(':','-',substr($v,0,stripos($v,' ')));
                         }
                    }
               }else{// process other files except image
                    return date('Y-m-d',filemtime($file));
               }
          }
     }
     // Usage Sample
     $SM = new SmartMan('D:\xxx');
     $SM->autoFile2DayDir();
