package org.cocos2d.actions.grid;

import org.cocos2d.cocoa.CCGeometry.CCPoint;
import org.cocos2d.cocoa.CCGeometry.CCSize;
import org.cocos2d.support.CCPointExtension;
import org.cocos2d.types.CCVertex3D;

////////////////////////////////////////////////////////////

/** CCRipple3D action */
public class CCRipple3D extends CCGrid3DAction {
	/** center position */
	CCPoint	position;
	
	float	radius;
	int		waves;

	/** amplitude */
	float	amplitude;
	/** amplitude rate */
	float	amplitudeRate;
	
	/** creates the action with radius, number of waves, amplitude, a grid size and duration */
	public static CCRipple3D action(CCPoint pos, float radius, 
			int wav,float amp, CCSize gridSize, float d)	{
		return new CCRipple3D(pos, radius, wav, amp, gridSize, d);
	}

	/** initializes the action with radius, number of waves, amplitude, a grid size and duration */
	public CCRipple3D(CCPoint pos, float r, int wav, float amp, 
			CCSize gSize, float d) {
		super(gSize, d);
		position = pos;
		radius = r;
		waves = wav;
		amplitude = amp;
		amplitudeRate = 1.0f;		
	}

	@Override
	public CCRipple3D copy() {
		CCRipple3D copy = new CCRipple3D(position, radius, waves, 
				amplitude, gridSize, duration);
		return copy;
	}


	@Override
	public void update(float time) {
		int i, j;
		
		for( i = 0; i < (gridSize.width+1); i++ ) {
			for( j = 0; j < (gridSize.height+1); j++ ) {
				CCVertex3D	v = originalVertex(CCPointExtension.ccp(i,j));
				CCPoint vect = CCPointExtension.ccpSub(position, CCPointExtension.ccp(v.x,v.y));
				float r = CCPointExtension.ccpLength(vect);
				
				if ( r < radius ) {
					r = radius - r;
					float rate = (float)Math.pow( r / radius, 2);
					v.z += (Math.sin( time*Math.PI*waves*2 + r * 0.1f) * amplitude * amplitudeRate * rate );
				}
				
				setVertex(CCPointExtension.ccp(i,j), v);
			}
		}
	}

}
