package org.cocos2d.actions.interval;

import org.cocos2d.base_nodes.CCNode;
import org.cocos2d.cocoa.CCGeometry.CCPoint;
import org.cocos2d.support.CCPointExtension;

/**
 * Moves a CCNode object simulating a parabolic jump movement by modifying it's position attribute.
*/
public class CCJumpBy extends CCIntervalAction {
    protected CCPoint startPosition = new CCPoint();
    protected CCPoint delta = new CCPoint();
    protected float height;
    protected int jumps;

    /** creates the action */
    public static CCJumpBy action(float time, CCPoint pos, float height, int jumps) {
        return new CCJumpBy(time, pos, height, jumps);
    }

    /** initializes the action */
    protected CCJumpBy(float time, CCPoint pos, float h, int j) {
        super(time);
        startPosition.setPoint(0, 0);
        delta.setPoint(pos);
        height = h;
        jumps = j;
    }

    @Override
    public CCJumpBy copy() {
        return new CCJumpBy(duration, delta, height, jumps);
    }

    @Override
    public void start(CCNode aTarget) {
        super.start(aTarget);
        CCPoint pnt = target.getPosition();
        startPosition.setPoint(pnt);
    }

    @Override
    public void update(float t) {
        // parabolic jump (since v0.8.2)
        float frac = (t * jumps) % 1.0f;
        float y = height * 4 * frac * (1 - frac);
        y += delta.y * t;
        float x = delta.x * t;
        target.setPosition(startPosition.x + x, startPosition.y + y);
    }

    @Override
    public CCJumpBy reverse() {
        return new CCJumpBy(duration, CCPointExtension.ccpNeg(delta), height, jumps);
    }
}

