package org.cocos2d.actions.tile;

import org.cocos2d.cocoa.CCGeometry.CCPoint;
import org.cocos2d.cocoa.CCGeometry.CCSize;
import org.cocos2d.support.CCPointExtension;
import org.cocos2d.types.ccGridSize;

////////////////////////////////////////////////////////////

/** CCFadeOutDownTiles action.
 Fades out the tiles in downwards direction
 */
public class CCFadeOutDownTiles extends CCFadeOutUpTiles {
	public static CCFadeOutDownTiles action(CCSize gSize, float d) {
		return new CCFadeOutDownTiles(gSize, d);
	}
	
	protected CCFadeOutDownTiles(CCSize gSize, float d) {
		super(gSize, d);
	}
	
	@Override
    public float testFunc(ccGridSize pos, float time) {
        CCPoint	n = CCPointExtension.ccpMult(CCPointExtension.ccp(gridSize.width,gridSize.height), (1.0f - time));
        if ( pos.y == 0 )
            return 1.0f;
        return (float)Math.pow( n.y / pos.y, 6 );
    }

}

