/*
Copyright (c) 2008, Luke Benstead.
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation
      and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

package org.cocos2d.kazmath;

public class Utility {

	public static final float kmPI = 3.141592f;
	public static final float kmPIOver180 = 0.017453f; //  PI / 180
	public static final float kmPIUnder180 = 57.295779f; // 180 / PI
	public static final float kmEpsilon = 1.0f / 64.0f;

	/**
	 * Returns the square of s (e.g. s*s)
	 */
	public static float kmSQR(float s) {
		return s*s;
	}

	/**
	 * Returns degrees as radians.
	 */
	public static float kmDegreesToRadians(float degrees) {
		return degrees * kmPIOver180;
	}

	/**
	 * Returns radians as degrees
	 */
	public static float kmRadiansToDegrees(float radians) {
		return radians * kmPIUnder180;
	}

	public static float kmMin(float lhs, float rhs) {
		return (lhs < rhs)? lhs : rhs;
	}

	public static float kmMax(float lhs, float rhs) {
		return (lhs > rhs)? lhs : rhs;
	}

	public static boolean kmAlmostEqual(float lhs, float rhs) {
		return (lhs + kmEpsilon > rhs && lhs - kmEpsilon < rhs);
	}
}
