package org.cocos2d.menu_nodes;

import org.cocos2d.nodes.CCLabel;

/**
 * @addtogroup GUI
 * @{
 * @addtogroup menu
 * @{
 */

/** @brief A CCMenuItemFont
 * Helper class that creates a CCMenuItemLabel class with a Label
 */
public class CCMenuItemFont extends CCMenuItemLabel {

	public CCMenuItemFont() {
		m_uFontSize = 0;
		m_strFontName = "";
	}

	/** set default font size */
	public static void setFontSize(int s) {
		 _globalFontSize = s;
	}

	/** get default font size */
	public static int fontSize() {
		return _globalFontSize;
	}

	/** set the default font name */
	public static void setFontName(String name) {
		_globalFontName = name;
		_globalFontNameRelease = true;
	}

	/** get the default font name */
	public static String fontName() {
		return _globalFontName;
	}

	/** creates a menu item from a string without target/selector. To be used with CCMenuItemToggle */
	public static CCMenuItemFont create(String value) {
		CCMenuItemFont pRet = new CCMenuItemFont();
		pRet.initWithString(value, null, null);
		return pRet;
	}

	/** creates a menu item from a string with a target/selector */
	public static CCMenuItemFont create(String value, Object target, String selector) {
		CCMenuItemFont pRet = new CCMenuItemFont();
		pRet.initWithString(value, target, selector);
		return pRet;
	}

	/** initializes a menu item from a string with a target/selector */
	public boolean initWithString(String value, Object target, String selector) {
		assert (value != null) && (value.length() != 0) : "Value length must be greater than 0";

		m_strFontName = _globalFontName;
		m_uFontSize = _globalFontSize;

// TODO		CCLabelTTF label = CCLabelTTF.create(value, m_strFontName, (float)m_uFontSize);
		CCLabel label = CCLabel.makeLabel(value, _globalFontName, _globalFontSize);
		if(super.initWithLabel(label, target, selector)) {
			// do something ?
		}
		return true;
	}

	/** set font size
	 * c++ can not overload static and non-static member functions with the same parameter types
	 * so change the name to setFontSizeObj
	 */
	public void setFontSizeObj(int s) {
		m_uFontSize = s;
		recreateLabel();
	}

	/** get font size */
	public int fontSizeObj() {
		return m_uFontSize;
	}

	/** set the font name 
	 * c++ can not overload static and non-static member functions with the same parameter types
	 * so change the name to setFontNameObj
	 */
	public void setFontNameObj(String name) {
		m_strFontName = name;
		recreateLabel();
	}

	public String fontNameObj() {
		return m_strFontName;
	}

	protected void recreateLabel() {
// TODO		CCLabelTTF label = CCLabelTTF.create(((CCLabelProtocol)m_pLabel).getString(), 
// TODO				m_strFontName, (float)m_uFontSize);
	}

	int m_uFontSize;
	String m_strFontName;
}

// end of GUI group
/// @}
/// @}
