package org.cocos2d.transitions;

import org.cocos2d.CCDirector;
import org.cocos2d.actions.interval.CCIntervalAction;
import org.cocos2d.actions.interval.CCMoveBy;
import org.cocos2d.cocoa.CCGeometry.CCSize;
import org.cocos2d.layers_scenes_transitions_nodes.CCScene;
import org.cocos2d.support.CCPointExtension;

/**
 * SlideInT Transition.
 * Slide in the incoming scene from the top border.
 */
public class CCSlideInTTransition extends CCSlideInLTransition {

    public static CCSlideInTTransition transition(float t, CCScene s) {
        return new CCSlideInTTransition(t, s);
    }

    public CCSlideInTTransition(float t, CCScene s) {
        super(t, s);
    }

    public void sceneOrder() {
        inSceneOnTop = false;
    }

    /**
     * initializes the scenes
     */
    protected void initScenes() {
        CCSize s = CCDirector.sharedDirector().getWinSizeInPixels();
        inScene.setPosition(0, s.height-ADJUST_FACTOR);
    }

    @Override
    public CCIntervalAction action() {
        CCSize s = CCDirector.sharedDirector().getWinSizeInPixels();
        return CCMoveBy.action(duration, CCPointExtension.ccp(0,-(s.height-ADJUST_FACTOR)));
    }

}
