package org.cocos2d.utils;

import org.cocos2d.cocoa.CCGeometry.CCPoint;
import org.cocos2d.cocoa.CCGeometry.CCRect;
import org.cocos2d.cocoa.CCGeometry.CCSize;
import org.cocos2d.support.CCPointExtension;

public class GeometryUtil {

	public static CCPoint CCPointFromString(String str) {
		String coords = str.replaceAll("[{|}]", "");
		String c[] = coords.split(",");
		return CCPointExtension.ccp(Float.parseFloat(c[0]), Float.parseFloat(c[1]));
	}

	public static CCSize CCSizeFromString(String str) {
		String coords = str.replaceAll("[{|}]", "");
		String c[] = coords.split(",");
		return CCSize.Make(Float.parseFloat(c[0]), Float.parseFloat(c[1]));
	}

	public static CCRect CCRectFromString(String str) {
		String c[] = str.replaceAll("[{|}]", "").split(",");
		return CCRect.Make(Float.parseFloat(c[0]),
			Float.parseFloat(c[1]),
			Float.parseFloat(c[2]),
			Float.parseFloat(c[3]));
	}
}
