//
//  ECTimelineManager.h
//  Etokicho
//
//  Created by 二鏡 on 11/12/07.
//  Copyright (c) 2011年 二鏡庵. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "ECDTimeline.h"
#import "ECDSegment.h"
@class ECScene;

@interface ECTimelineManager : NSObject
{
    NSManagedObjectContext *context;
    NSIndexSet *selection;
    ECDTimeline *timeline; // singleton cache
    NSInteger changeCount;
}
@property (readonly) NSManagedObjectContext *context;
@property (readwrite,copy) NSIndexSet *selection;
@property (readonly) NSUndoManager *undoManager;
@property (readonly) ECDTimeline *timeline;

- (BOOL)isEmpty;
- (BOOL)hasChange;
- (void)resetUndo; // undoスタックを削除して再初期化に備える
- (void)reset;
- (void)resetWithFPS:(NSInteger)fps;

- (ECDSegment*)selectedSegment;
@end

@interface ECTimelineManager (Service)
- (NSArray*)aroundScenesOfSelectedSegment;
// transition編集用のサービスメソッド
// selectionの前後のシーンセグメントを返す
// 無・複数選択の場合はnil
// 常に2値の配列で前後がシーンでない場合はNot Applicableで返す。境界状態も含む

@property (readonly) ECScene *posterScene;
- (NSString*)totalTimeString;

- (NSArray*)segmentsOfObjectIDURIs:(NSArray*)URIs;
- (NSArray*)cloneSegments:(NSArray*)segments;
@end


@interface ECTimelineManager (Undo)
- (void)startUndoTracking:(NSUndoManager*)undo;
- (void)stopUndoTracking:(NSUndoManager*)undo;
- (void)updateChangeCount:(NSDocumentChangeType)val;
@end
