//
//  MSLayoutBlock.m
//  Manuscript
//
//  Created by 二鏡 on 12/03/02.
//  Copyright (c) 2012年 二鏡庵. All rights reserved.
//


#import "MSLayoutBlock.h"

@implementation MSLayoutBlock
@synthesize lines = lines_, characterLocation = characterLocation_, lineOffset = lineOffset_;

- (id)initWithAttributedString:(NSAttributedString*)aString
{
    src_ = new CompiledAttributedString(aString);
    characterLocation_ = 0;
    lineOffset_ = 0;
    return self;
}

- (CompiledAttributedString*)string
{
    return src_;
}

- (NSString*)description
{
    id ret = [NSString stringWithFormat: @"<#%xMSLayoutBlock>\nL:{%ld,%ld}\n,C:{%ld,%ld}\n%@",self, lineOffset_, [lines_ count], characterLocation_, src_->length(), src_->description()];
    return ret;
}

- (void)finalize
{
    delete src_;
    [super finalize];
}

- (NSUInteger)characterLength
{
    return src_->length();
}

- (NSRange)characterRange
{
    CFIndex length = src_->length();
    return NSMakeRange(characterLocation_, length);
}

- (void)setLines:(NSArray*)lines
{
    lines_ = [lines copy];
    for(VTLogicalLineContainer *line in lines_)
        line.container = self;
}

- (BOOL)isClosed
{
    return src_->closed();
}

- (VTLogicalLineContainer*)lineAtCharacterIndex:(NSUInteger)blockLocal
{
    for(VTLogicalLineContainer *container in lines_)
    {
        const LogicalLine *line = container.line;
        CFRange range = line->get_character_range();
        if(_CFLocationInRange(blockLocal, range))
        {
            return container;
        }
        
    }
    return nil;
}

- (NSUInteger)lineIndexAtCharacterIndex:(NSUInteger)blockLocal
{
    NSUInteger i=0;
    for(VTLogicalLineContainer *container in lines_)
    {
        const LogicalLine *line = container.line;
        CFRange range = line->get_character_range();
        if(_CFLocationInRange(blockLocal, range))
        {
            return i;
        }
        i++;
    }
    return NSNotFound;
}

- (NSUInteger)convertCharacterIndexToLocal:(NSUInteger)globalIndex
{
    return globalIndex - characterLocation_;
}

- (NSUInteger)convertCharacterIndexToGlobal:(NSUInteger)blockLocalIndex
{
    return blockLocalIndex + characterLocation_;
}
@end
