//
//  MSPager.h
//  Manuscript
//
//  Created by 二鏡 on 12/02/11.
//  Copyright (c) 2012年 二鏡庵. All rights reserved.
//


#import <Foundation/Foundation.h>
#import "ClusterMappingCache.h"

@class MSPageFormat;
@class MSTextView;
@class MSLayoutBlockManager;
@class MSTypesetter;

@interface MSPager
: NSObject <NSTextStorageDelegate>
{
    ClusterMappingCache syncCache_; // paragraph->line mapping cache
    MSPageFormat *format_;
    NSMutableArray *lines_;
    MSTextView *textView_;
    MSLayoutBlockManager *content_;    
    MSTypesetter *typesetter_;
    
    NSRange touchedRange_;
}

@property (readwrite,assign) MSLayoutBlockManager *content;
@property (readwrite,assign) MSPageFormat *format;
@property (readwrite,assign) MSTextView *textView;

- (void)updateViewSize;
- (void)drawGrid:(NSRect)dirtyRect;
- (void)drawSelectionInRect:(NSRect)dirtyRect
             characterRange:(NSRange)characterRange;
- (void)drawLinesInRect:(NSRect)dirtyRect;
- (NSUInteger)lineIndexAtPoint:(NSPoint)aPoint; // extra fragmentを指す行([lines_ count])も来るので注意
- (NSUInteger)lineIndexOfCharacterIndex:(NSUInteger)charIndex;
- (NSPoint)lineOriginAtIndex:(NSUInteger)lineIndex;
- (NSUInteger)indexOfCharacterAtPoint:(NSPoint)aPoint;
- (NSUInteger)indexOfCharacterOfNearestBorderAtPoint:(NSPoint)aPoint // 最も近いボーダーからcharIndex
                                              isTail:(BOOL*)isTail;
- (NSUInteger)indexOfCharacterOfPreviousLineFromPoint:(NSPoint)aPoint; // 前の行へ移動した時のcharIndex
- (NSUInteger)indexOfCharacterOfNextLineFromPoint:(NSPoint)aPoint; // 次の行へ移動した時のcharIndex
// 行が存在しない時は、NSNotFoundを返す

// 改行文字以外の行の末尾文字のindexを返す
- (NSUInteger)endOfLineAtCharacterIndex:(NSUInteger)charIndex;
- (NSUInteger)beginningOfLineAtCharacterIndex:(NSUInteger)charIndex;

- (NSRect)firstRectForCharacterRange:(NSRange)aRange // view座標で返す
                         actualRange:(NSRangePointer)actualRange;
- (NSRect)caretRectForCharacterIndex:(NSUInteger)index;
- (NSRect)caretRectForCharacterIndexWithExtend:(NSUInteger)index; // 行末を含んでも良いバージョン

- (NSImage*)generateTextImageForDraggingOfRange:(NSRange)characterRange
                                         inRect:(NSRect*)rect;
@end
