//
//  _GlyphLocator.cpp
//  Manuscript
//
//  Created by 二鏡 on 11/07/28.
//  Copyright 2011年 二鏡庵. All rights reserved.
//

#include "_GlyphLocator.h"

void _GlyphBufferSpace::loadString(CompiledAttributedString *value)
{
    target = value;
    // reserve capacity
    unsigned long size = target->characters.size();
    this->resizeBuffer(size);

    vector<AttributesAdapter>::const_iterator it = target->attributes.begin();
    for(;it != target->attributes.end();it++)
    {
        CFRange range = it->first;
        // characters -> glyphs
        NSFont *font = it->second.font;
        const UniChar *char_ptr = &(target->characters[range.location]);
        CGGlyph *glyph_ptr = &glyphs[range.location];
        CTFontGetGlyphsForCharacters((CTFontRef)font, char_ptr, glyph_ptr, range.length);
    }
}

void _GlyphBufferSpace::loadStage1substitute()
{
    vector<AttributesAdapter>::const_iterator it = target->attributes.begin();
    for(;it != target->attributes.end(); it++)
    {
        CFRange range = it->first;
        NSFont *font = it->second.font;
        const UniChar *char_ptr = &(target->characters[range.location]);
        CGGlyph *glyph_ptr = &(glyphs[range.location]);
        if(delegate)
            [delegate substituteGlyphs: glyph_ptr
                            characters: char_ptr
                                 count: range.length
                                inFont: font];
    }
}

void _GlyphBufferSpace::loadStage2metrics(CTFontOrientation orientation)
{
    CGSize *advance_ptr = &(advances[0]);
    CGSize *translate_ptr = &translations[0];
    GlyphMetricsCache *storage = NULL;
    GlyphMetricsLoader &loader = glyphLoader;
    
    vector<AttributesAdapter>::const_iterator it = target->attributes.begin();
    for(;it != target->attributes.end(); it++)
    {
        CFRange range = it->first;
        CTFontRef font = (CTFontRef)it->second.font;
        loader.font = font;
        storage = gGlyphMetricsCacheTable.getCache(font);
        
        // copy trans & adv in range
        CFIndex limit = range.location+range.length;
        for(CFIndex i=range.location;i<limit;i++)
        {
            CGGlyph glyph = glyphs[i];
            const GlyphMetrics *metric = storage->find(glyph);
            if(metric == NULL)
            {
                // capacity check
                if(glyphLoader.push(glyph,(uint32_t)i) == false)
                {
                    loader.load(orientation);
                    loader.write_back(translate_ptr, advance_ptr);
                    loader.memory(storage);
                    loader.reset();
                }
            }
            else
            {
                translations[i] = metric->translate;
                advances[i] = metric->advance;
            }
        }
    }
    if(storage)
    {
        loader.load(orientation);
        loader.write_back(translate_ptr, advance_ptr);
        loader.memory(storage);
        loader.reset();
    }
}

void _GlyphBufferSpace::loadStage3attributes()
{
    const UniChar *char_ptr = &(target->characters[0]);
    CFIndex length = target->characters.size();
    uint8 *attr_ptr = &(characterAttribute[0]);
    [delegate parseCharacters: char_ptr
                 toAttributes: attr_ptr
                       length: length];
}
