//
//  Header.h
//  
//
//  Created by 二鏡 on 11/07/25.
//  Copyright 2011年 二鏡庵. All rights reserved.
//

#ifndef VTKit_GlyphCluster_h
#define VTKit_GlyphCluster_h

#import <ApplicationServices/ApplicationServices.h>

typedef void (*draw_function_p)(CTFontRef, const CGGlyph*, const CGPoint*, size_t, CGContextRef);
static const float cScaleByFont = 12.0;

class GlyphCluster {
    static draw_function_p _glyph_drawer;
    CFIndex count;
    CGGlyph *glyphs;
    CGPoint *points;
    
    NSFont *font;
    NSColor *color;
    
public:
    uint32_t underline_style;
    uint32_t strikethrough_style;
    NSColor *underline_color;
    NSColor *strikethrough_color;
    bool segment;
    CGFloat bounds_top;
    CGFloat bounds_bottom;
    
private:
#pragma mark sub drawing
    void _draw_underline(CGContextRef context, CGPoint origin, CGFloat magnification) const
    {
        [underline_color set];
        CGFloat fontSize = [font pointSize];
        CGFloat x = origin.x + fontSize/2.0+2;
        CGFloat y = origin.y + bounds_top;
        CGFloat w = fontSize/cScaleByFont*magnification;
        CGFloat h = bounds_bottom - bounds_top;
        
        if(segment)
            h-=2.0;
        NSRect rect = NSMakeRect(x,y,w,h);
        NSRectFill(rect);
    }
    
    void _draw_underline_double(CGContextRef context, CGPoint origin) const
    {
        [underline_color set];
        CGFloat fontSize = [font pointSize];
        CGFloat x = origin.x + fontSize/2.0+2;
        CGFloat y = origin.y + bounds_top;
        CGFloat w = fontSize/cScaleByFont;
        CGFloat h = bounds_bottom - bounds_top;
        
        NSRect rect1 = NSMakeRect(x,y,w,h);
        NSRect rect2 = NSMakeRect(x+w*2,y,w,h);
        NSRectFill(rect1);
        NSRectFill(rect2);
    }
    
    void _draw_strikethrough(CGContextRef context, CGPoint origin, CGFloat magnification) const
    {
        [strikethrough_color set];
        CGFloat fontSize = [font pointSize];
        CGFloat x = origin.x;
        CGFloat y = origin.y + bounds_top;
        CGFloat w = floor(fontSize/cScaleByFont*magnification);
        CGFloat h = bounds_bottom - bounds_top;
        
        NSRect rect = NSMakeRect(x,y,w,h);
        NSRectFill(rect);
    }
    
    void _draw_strikethrough_double(CGContextRef context, CGPoint origin) const
    {
        [strikethrough_color set];
        CGFloat fontSize = [font pointSize];
        CGFloat x = origin.x;
        CGFloat y = origin.y + bounds_top;
        CGFloat w = floor(fontSize/cScaleByFont);
        CGFloat h = bounds_bottom - bounds_top;
        
        NSRect rect1 = NSMakeRect(x-2*w,y,w,h);
        NSRect rect2 = NSMakeRect(x+2*w,y,w,h);
        NSRectFill(rect1);
        NSRectFill(rect2);
    }
    
    inline void _draw_extra(CGContextRef context) const
    {
        CGPoint origin = CGContextGetTextPosition(context);
        switch(underline_style & 0x0f)
        {
            case NSUnderlineStyleSingle:
                _draw_underline(context, origin, 1.0);
                break;
            case NSUnderlineStyleThick:
                _draw_underline(context, origin, 1.5);
                break;
            case NSUnderlineStyleDouble:
                _draw_underline_double(context, origin);
                break;
            case NSUnderlineStyleNone:
                break; // do nothing
        }
        
        switch(strikethrough_style & 0x0f)
        {
            case NSUnderlineStyleSingle:
                _draw_strikethrough(context,origin,1.0);
                break;
            case NSUnderlineStyleThick:
                _draw_strikethrough(context,origin,1.5);
                break;
            case NSUnderlineStyleDouble:
                _draw_strikethrough_double(context,origin);
                break;
            case NSUnderlineStyleNone:
                break; // do nothing
        }
    }
    
#pragma mark -
#pragma mark Public
public:
    static void intialize_rederning_system()
    {
        _glyph_drawer = CTFontDrawGlyphs;
    }
    
    GlyphCluster(NSFont *aFont, const CGGlyph *__restrict__ aGlyphs, const CGPoint *__restrict__ aPoints, const CFIndex aCount)
    {
        font = aFont;
        count = aCount;
        
        glyphs = new CGGlyph[count];
        points = new CGPoint[count];
        
        underline_style = 0;
        strikethrough_style = 0;
        underline_color = nil;
        strikethrough_color = nil;
        
        NSCopyMemoryPages(aGlyphs, glyphs, sizeof(CGGlyph)*count);
        NSCopyMemoryPages(aPoints, points, sizeof(CGPoint)*count);
        
        color = [NSColor blackColor];
    }
    
    ~GlyphCluster()
    {
        delete [] glyphs;
        delete [] points;
    }
    
    inline NSFont* getFont() const
    {
        return font;
    }
    
    inline NSColor* getColor() const
    {
        return color;
    }
    
    inline void setColor(NSColor *aColor)
    {
        color = aColor;
    }    
    
    void draw(CGContextRef context) const
    {
        [color set];
        _glyph_drawer((CTFontRef)font, glyphs, points, count, context);
        _draw_extra(context);
    }
};
#endif
