//
//  CaretState.h
//  Okusa
//
//  Created by 木谷 洋 on 12/03/19.
//  Copyright (c) 2012年 二鏡庵. All rights reserved.
//


#ifndef Okusa_CaretState_h
#define Okusa_CaretState_h
#import <Foundation/Foundation.h>

// キャレット周り
class CaretState
{
    CGFloat height_; // 行移動時に基準とする高さ
    bool hidden_; // 表示を行うか
    bool lock_;   // 編集中のlock.
    bool extended_; // 末端にいるか
    NSRect rect_; // キャレットの位置
public:
    NSUInteger locator; 
    // キャレットのlocator.普段はselectionと一致するが、ドラッグ中は一時的に変更されるため、
    // 別の値として保持する
    
    CaretState()
    {
        height_ = -1.0;
        lock_ = false;
        extended_ = false;
        hidden_ = false;
        locator = 0;
        rect_ = NSZeroRect;
    }
    
#pragma mark caret
    inline void invalide_rect() 
    {
        rect_ = NSZeroRect;
    }
    
    inline bool is_valid_rect()
    {
        return !NSEqualRects(rect_, NSZeroRect);
    }
    
    inline NSRect get_rect() const
    {
        return rect_;
    }
    
    inline void set_rect(NSRect rect)
    {
        rect_ = rect;
    }
#pragma mark lock
    inline bool is_locked() const
    {
        return lock_;
    }
    
    inline void lock() 
    {
        lock_ = true;
    }
    
    inline void unlock()
    {
        lock_ = false;
    }
    
#pragma mark hidden
    inline bool hidden() const
    {
        return hidden_;
    }
    
    inline void show()
    {
        hidden_ = false;
    }
    
    inline void hide()
    {
        hidden_ = true;
    }
    
    inline void toggle_hidden()
    {
        hidden_ = !hidden_;
    }
    
#pragma mark extension
    inline bool is_extended() const
    {
        return extended_;
    }
    
    inline void extend()
    {
        extended_ = true;
    }
    
    inline void cancel_extend()
    {
        extended_ = false;
    }
    
#pragma mark height
    inline void clear_height()
    {
        height_ = -1.0;
    }
    inline bool has_valid_height() const
    {
        return height_ >= 0.0;
    }
    inline CGFloat get_height() const
    {
        return height_;
    }
    
    inline void set_height(CGFloat val)
    {
        height_ = val;
    }
};
#endif
