//
//  MSPageFormat.m
//  Okusa
//
//  Created by 木谷 洋 on 12/02/11.
//  Copyright (c) 2012年 二鏡庵. All rights reserved.
//

#import "MSPageFormat.h"
static CGFloat cBoxPadding = 2.0; // 枠線分の幅二つ分

@implementation MSPageFormat
{
    CGFloat boundingWidth_;
}

@synthesize spacingMode = spacingMode_, padding = padding_, fontName = fontName_, fontSize = fontSize_, boundingWidth = boundingWidth_, boxCount = boxCount_;

- (id)initWithSpacingMode:(eLineSpacingMode)aMode
                  padding:(NSSize)aPadding
                 fontName:(NSString*)aName
                 fontSize:(CGFloat)aSize
                 boxCount:(NSUInteger)aCount;
{
    spacingMode_ = aMode;
    padding_ = aPadding;
    fontName_ = [aName copy];
    fontSize_ = aSize;
    boxCount_ = aCount;
    
    boundingWidth_ = self.boxSize;
    switch(spacingMode_)
    {
        case eLineSpacingMode_None:
            break;
        case eLineSpacingMode_Half:
            boundingWidth_ *= 1.5;
            break;
        case eLineSpacingMode_Full:
            boundingWidth_ *= 2.0;
            break;
    }
    return self;
}

- (CGFloat)boxSize
{
    return fontSize_+cBoxPadding;
}

- (NSFont*)font
{
    return [NSFont fontWithName: fontName_ size:fontSize_];
}

- (CGFloat)interline
{
    return boundingWidth_ - self.boxSize;
}

- (CGFloat)lineMarkBorder
{
    const CGFloat cBoxSize = fontSize_+cBoxPadding;
    return (boxCount_-1)*cBoxSize;
}

- (NSSize)standardSizeForNewWindow
{
    CGFloat w = boundingWidth_*20+padding_.width*2;
    CGFloat h = self.boxSize*(boxCount_+2)+padding_.height*2;
    return NSMakeSize(w,h);
}

- (NSAttributedString*)formatString:(NSString*)string
{
    id attr = [NSDictionary dictionaryWithObjectsAndKeys: [self font], NSFontAttributeName,
               [NSColor blackColor], NSForegroundColorAttributeName, 
               nil];
    
    id ret = [[NSAttributedString alloc] initWithString: string
                                             attributes: attr];
    return ret;
}
@end

