package org.dyndns.nuda.di;

import java.lang.reflect.Field;

import org.dyndns.nuda.logger.CommonLogger;
import org.dyndns.nuda.logger.LoggerAdaptor;
import org.dyndns.nuda.logger.LoggerAdaptorInjection;
import org.dyndns.nuda.logger.StandardConsoleLoggerAdaptor;
import org.dyndns.nuda.plugin.PluginDescription;

/**
 * DI機能としてロガーをフィールドインジェクションするInjectorです
 * @author koseki
 *
 */
@PluginDescription(name="ロガーアダプターインジェクタ")
public class LoggerAdaptorInjector implements Injector {
	
	private static LoggerAdaptor logger = CommonLogger.getLoggerAdaptor().getLogger("LoggerAdaptorInjector");

	@Override
	public void init() {
		logger.debug("{}", "ロガーアダプタインジェクタを初期化します");
		InjectorManager.addInjector(this);
	}

	@Override
	public void inject(Object target) {
		if (target == null) {
			return;
		}

		// LoggerAdaptorのDI
		Class<?> cls = target.getClass();
		Field[] fields = cls.getDeclaredFields();

		for (Field targetField : fields) {
			boolean isValid = targetField
					.isAnnotationPresent(LoggerAdaptorInjection.class);

			Class<?> fieldType = targetField.getType();
			if (fieldType.equals(LoggerAdaptor.class) && isValid) {
				boolean isAccessible = targetField.isAccessible();
				if (!isAccessible) {
					targetField.setAccessible(true);
				}

				LoggerAdaptor adaptor = null;

				LoggerAdaptorInjection inj = targetField
						.getAnnotation(org.dyndns.nuda.logger.LoggerAdaptorInjection.class);
				if (inj.name().isEmpty()) {
					adaptor = CommonLogger.getLoggerAdaptor().getLogger(cls);
				} else {
					adaptor = CommonLogger.getLoggerAdaptor().getLogger(
							inj.name());
				}

				if (java.lang.reflect.Modifier.isStatic(targetField
						.getModifiers())) {
					try {
						targetField.set(null, adaptor);
					} catch (IllegalArgumentException e) {
						e.printStackTrace();
					} catch (IllegalAccessException e) {
						e.printStackTrace();
					}
				} else {
					try {
						targetField.set(target, adaptor);
					} catch (IllegalArgumentException e) {
						e.printStackTrace();
					} catch (IllegalAccessException e) {
						e.printStackTrace();
					}
				}

				targetField.setAccessible(isAccessible);
			}

		}
	}

}
