package org.dyndns.nuda.tools.xml;

import java.util.Stack;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public enum SQLXMLScope implements ScopeHandler<SQLXMLResultBean> {
	statements {
		
		@Override
		public void startElement(final Context<SQLXMLResultBean> ctx,
				final String uri, final String localName, final String qName,
				final Attributes attributes) throws SAXException {
		}
		
		@Override
		public void endElement(final Context<SQLXMLResultBean> ctx,
				final String uri, final String localName, final String qName)
				throws SAXException {
		}
		
		@Override
		public void characters(final Context<SQLXMLResultBean> ctx,
				final char[] ch, final int start, final int length)
				throws SAXException {
		}
	},
	statement {
		
		@Override
		public void startElement(final Context<SQLXMLResultBean> ctx,
				final String uri, final String localName, final String qName,
				final Attributes attributes) throws SAXException {
			SQLXMLBean current = new SQLXMLBean();
			StringBuilder b = new StringBuilder();
			ctx.getValue().setCurrentStatement(b);
			ctx.getValue().setCurrentContext(current);
			String id = attributes.getValue("id");
			String type = attributes.getValue("type");
			
			current.setId(id);
			current.setType(type);
		}
		
		@Override
		public void endElement(final Context<SQLXMLResultBean> ctx,
				final String uri, final String localName, final String qName)
				throws SAXException {
			StringBuilder b = ctx.getValue().getCurrentStatement();
			SQLXMLBean current = ctx.getValue().getCurrentContext();
			current.setStatement(b.toString());
			ctx.getValue().put(current.getId(), current);
		}
		
		@Override
		public void characters(final Context<SQLXMLResultBean> ctx,
				final char[] ch, final int start, final int length)
				throws SAXException {
			
			String s = new String(ch, start, length);
			StringBuilder b = ctx.getValue().getCurrentStatement();
			b.append(s);
		}
	},
	invalid {
		
		@Override
		public void startElement(final Context<SQLXMLResultBean> ctx,
				final String uri, final String localName, final String qName,
				final Attributes attributes) throws SAXException {
		}
		
		@Override
		public void endElement(final Context<SQLXMLResultBean> ctx,
				final String uri, final String localName, final String qName)
				throws SAXException {
		}
		
		@Override
		public void characters(final Context<SQLXMLResultBean> ctx,
				final char[] ch, final int start, final int length)
				throws SAXException {
		}
	};
	
	@Override
	public ScopeHandler<SQLXMLResultBean> changeScope(
			final Stack<ScopeHandler<SQLXMLResultBean>> scopeStack,
			final String qName) {
		
		return SQLXMLScope.valueOf(qName);
	}
	
	@Override
	public ScopeHandler<SQLXMLResultBean> defaultScope() {
		return invalid;
	}
	
}
