package org.dyndns.nuda.tools.util;

import java.lang.reflect.Field;
import java.util.ArrayList;

import junit.framework.TestCase;

import org.dyndns.nuda.tools.util.mock.TestBean;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import com.sun.xml.internal.bind.v2.schemagen.xmlschema.List;

public class ReflectUtilTest extends TestCase {
	
	@Override
	@Before
	public void setUp() throws Exception {
	}
	
	@Override
	@After
	public void tearDown() throws Exception {
	}
	
	@Test
	public void testIsPresentedByInterface01() {
		Class<?> a = List.class;
		Class<?> b = ArrayList.class;
		
		boolean actual = ReflectUtil.isPresentedByInterface(b, a);
		
		assertEquals(true, actual);
	}
	
	@Test
	public void testIsPresentedByInterface02() {
		Class<?> a = List.class;
		Class<?> b = ArrayList.class;
		
		boolean actual = ReflectUtil.isPresentedByInterface(a, b);
		
		assertEquals(false, actual);
	}
	
	@Test
	public void testIsPresentedByInterface03() {
		Class<?> a = List.class;
		Class<?> b = ArrayList.class;
		
		boolean actual = ReflectUtil.isPresentedByInterface(Integer.class, String.class);
		
		assertEquals(false, actual);
	}
	
	@Test
	public void testGetAnnotationPresentedMethods() {
		fail("まだ実装されていません");
	}
	
	@Test
	public void testGetAnnotationPresentedField() {
		fail("まだ実装されていません");
	}
	
	@Test
	public void testGetGenericTypeForMethodReturn() {
		fail("まだ実装されていません");
	}
	
	@Test
	public void testGetGenericParameterType01() {
		TestBean<String> target = new TestBean<String>();
		target.targetField = new ArrayList<String>();
		Class<?> cls = target.getClass();
		try {
			System.out.println("start:" + cls);
			for(Field f : cls.getDeclaredFields()) {
				System.out.println(f);
			}
			Field f = cls.getDeclaredField("targetField");
			
			Class<?> actual = ReflectUtil.getParameterGenericType(f);
			
			System.out.println(">" + actual);
			assertEquals(String.class, actual);
			
		} catch(Exception e) {
			
			fail(">" + e.getMessage());
		}
		
		
	}
}
