package org.dyndns.nuda.dynamic.compiler.resolver;

import java.util.ArrayList;
import java.util.List;

import org.dyndns.nuda.dynamic.compiler.SourceBean;
import org.dyndns.nuda.dynamic.compiler.SourceResolver;

/**
 * 入力ソースによって自動的にリゾルバクラスを決定するリゾルバクラスです
 * 
 * @author nkoseki
 * 
 */
public class AutoResolver implements SourceResolver {
	
	private SourceResolver			resolverImpl	= new NOPResolver();
	private static List<SourceResolver>	resolverList	= new ArrayList<SourceResolver>();
	
	private Object					target;
	
	@Override
	public SourceBean resolve() {
		this.resolverImpl = new NOPResolver();
		for (SourceResolver resolver : resolverList) {
			if (resolver.accept(this.target)) {
				resolver.setTarget(this.target);
				this.resolverImpl = resolver;
				break;
			}
		}
		
		return this.resolverImpl.resolve();
	}
	
	private AutoResolver(final Object target) {
		this.target = target;
		
	};
	
	public static AutoResolver getInstance() {
		return new AutoResolver(null);
	}
	
	public static AutoResolver getInstance(final Object target) {
		return new AutoResolver(target);
	}
	
	public static void addResolver(final SourceResolver resolver) {
		if(resolver != null) {
			System.out.println("AutoResolver:次のリゾルバを追加します:" + resolver.getClass().getCanonicalName());
			resolverList.add(resolver);
		}
	}
	
	@Override
	public boolean accept(final Object target) {
		return false;
	}
	
	@Override
	public void setTarget(final Object target) {
		this.target = target;
	}
	
	@Override
	public Object getTarget() {
		return this.target;
	}

	@Override
	public void init() {
		// TODO Auto-generated method stub
		
	}
}
