package org.dyndns.nuda.logger;

import java.text.SimpleDateFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.dyndns.nuda.tools.util.StringUtil;

public class StandardConsoleLoggerAdaptor implements LoggerAdaptor {

	private String _loggerName = "";
	
	private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy/MM/dd hh:mm:ss");
	
	private Logger logger = Logger.getLogger("default");
	
	@Override
	public String getRecommendVersion() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getLoggerClassName() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Class<?> getLoggerClass() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public LoggerAdaptor getLogger(String loggerName) {
		_loggerName = loggerName;
		logger = Logger.getLogger(_loggerName);
		return this;
	}

	@Override
	public LoggerAdaptor getLogger(Class<?> targetClass) {
		if(targetClass != null) {
			_loggerName = targetClass.getCanonicalName();
			logger = Logger.getLogger(_loggerName);
		} else {
			_loggerName = "default";
			logger = Logger.getLogger(_loggerName);
		}
		return this;
	}

	@Override
	public void trace(String format, Object... params) {
		String message = StringUtil.format(format, params);
		//String realMessage = StringUtil.format("[{}][{}][{}]\t\t{}", _loggerName, "TRACE", SDF.format(new Date()), message);
		//logger.log(Level., msg)
		logger.log(Level.INFO, message);
		//System.err.println(realMessage);
	}

	@Override
	public void trace(String message, Throwable t) {
//		String realMessage = StringUtil.format("[{}][{}][{}]\t\t{}\n\t{}", _loggerName, "TRACE", SDF.format(new Date()), message, t.getMessage());
//		System.err.println(realMessage);
		
		logger.log(Level.INFO, message, t);
	}

	@Override
	public void debug(String format, Object... params) {
		String message = StringUtil.format(format, params);
		//String realMessage = StringUtil.format("[{}][{}][{}]\t\t{}", _loggerName, "DEBUG", SDF.format(new Date()), message);
		logger.log(Level.INFO, message);
	}

	@Override
	public void debug(String message, Throwable t) {
		//String realMessage = StringUtil.format("[{}][{}][{}]\t\t{}\n\t{}", _loggerName, "DEBUG", SDF.format(new Date()), message, t.getMessage());
		logger.log(Level.INFO, message, t);
	}

	@Override
	public void info(String format, Object... params) {
		String message = StringUtil.format(format, params);
		//String realMessage = StringUtil.format("[{}][{}][{}]\t\t{}", _loggerName, "INFO", SDF.format(new Date()), message);
		logger.log(Level.INFO, message);
	}

	@Override
	public void info(String message, Throwable t) {
//		String realMessage = StringUtil.format("[{}][{}][{}]\t\t{}\n\t{}", _loggerName, "INFO", SDF.format(new Date()), message, t.getMessage());
		logger.log(Level.INFO, message, t);
	}

	@Override
	public void warn(String format, Object... params) {
		String message = StringUtil.format(format, params);
//		String realMessage = StringUtil.format("[{}][{}][{}]\t\t{}", _loggerName, "WARN", SDF.format(new Date()), message);
		logger.log(Level.WARNING, message);
	}

	@Override
	public void warn(String message, Throwable t) {
//		String realMessage = StringUtil.format("[{}][{}][{}]\t\t{}\n\t{}", _loggerName, "WARN", SDF.format(new Date()), message, t.getMessage());
		//System.err.println(realMessage);
		logger.log(Level.WARNING, message, t);
	}

	@Override
	public void error(String format, Object... params) {
		String message = StringUtil.format(format, params);
//		String realMessage = StringUtil.format("[{}][{}][{}]\t\t{}", _loggerName, "ERROR", SDF.format(new Date()), message);
		//System.err.println(realMessage);
		logger.log(Level.WARNING, message);
	}

	@Override
	public void error(String message, Throwable t) {
//		String realMessage = StringUtil.format("[{}][{}][{}]\t\t{}\n\t{}", _loggerName, "ERROR", SDF.format(new Date()), message, t.getMessage());
		//System.err.println(realMessage);
		logger.log(Level.WARNING, message, t);
	}

	@Override
	public void fatal(String format, Object... params) {
		String message = StringUtil.format(format, params);
//		String realMessage = StringUtil.format("[{}][{}][{}]\t\t{}", _loggerName, "FATAL", SDF.format(new Date()), message);
//		System.err.println(realMessage);
		logger.log(Level.SEVERE, message);
	}

	@Override
	public void fatal(String message, Throwable t) {
//		String realMessage = StringUtil.format("[{}][{}][{}]\t\t{}\n\t{}", _loggerName, "FATAL", SDF.format(new Date()), message, t.getMessage());
//		System.err.println(realMessage);
		logger.log(Level.SEVERE, message, t);
	}

}
