package jp.gr.java_conf.noboru.android.droidcube;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.GestureDetector;
import android.view.GestureDetector.OnGestureListener;
import android.view.MotionEvent;
import android.view.View;

public class GameMain extends Activity implements OnGestureListener {
	public static final int FIRST = 0;

	GameView gameView;

	GestureDetector gestureDetector;

	protected boolean isFullscreenOpaque() {
		// Our main window is set to translucent, but we know that we will
		// fill it with opaque data. Tell the system that so it can perform
		// some important optimizations.
		return true;
	}

	@Override
	protected void onCreate(Bundle icicle) {
		Log.d(DroidCube.TAG, "GameMain#onCreate start");

		super.onCreate(icicle);
		int type = getIntent().getExtras().getInt(DroidCube.GL_DRAW);
		Log.d(DroidCube.TAG, "type=" + type);

		gameView = new GameView(this);
		View v = null;
		switch (type) {
		case FIRST:
			Log.d(DroidCube.TAG, "GameView#GameView call");
			v = gameView;
			Log.d(DroidCube.TAG, "GameView#GameView called");
			break;
		}
		setContentView(v);

		gestureDetector = new GestureDetector(this);
	}

	@Override
	public boolean onTouchEvent(MotionEvent event) {
		return gestureDetector.onTouchEvent(event);
	}

	@Override
	public boolean onDown(MotionEvent e) {
		Log.d(DroidCube.TAG, "onDown e=" + e);
		return true;
	}

	@Override
	public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX,
			float velocityY) {
		return true;
	}

	@Override
	public void onLongPress(MotionEvent e) {
		Log.d(DroidCube.TAG, "onLongPress e=" + e);
		// 何もしない
	}

	@Override
	public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX,
			float distanceY) {
		Log.d(DroidCube.TAG, "e1=" + e1 + ",e2=" + e2 + ",distanceX="
				+ distanceX + ",distanceY="
				+ distanceY);
		gameView.rotate(-distanceY, -distanceX);
		return true;
	}

	@Override
	public void onShowPress(MotionEvent e) {
		Log.d(DroidCube.TAG, "onShowPress e=" + e);
		// 何もしない
	}

	@Override
	public boolean onSingleTapUp(MotionEvent e) {
		Log.d(DroidCube.TAG, "onSingleTapUp e=" + e);
		return true;
	}
}
