#!/usr/bin/env python
# coding:UTF-8
#
# PiLog Library for HMR2300
#
"""
HMR2300デバイス固有関数

詳細説明文1
詳細説明文2
"""
__author__ = 'ntaka'
__version__ = '0.1'

from pilog import cmdsend, resrcv
eol = '\r'

def init_device(port):
    """
    HMR2300デバイスの初期化コマンドをシリアル送信する
    工場出荷状態にリセットしてアスキー出力にする
    """
    # Write Enable
    cmdsend(port, "*99WE")
    resrcv(port)
    # Factory settings
    cmdsend(port, "*99WE *99D")
    resrcv(port)
    resrcv(port)
    # Write Enable
    cmdsend(port, "*99WE")
    resrcv(port)
    # Ascii
    cmdsend(port, "*99PWE *99A")
    resrcv(port)

def _decode_sub(b, i):
    """
    文字列から磁場値1成分の部分を抜き出す
    b: 変換する先頭文字の位置 0〜
    i: 変換元文字列
    """
    return i[b] + i[b+1:b+3] + i[b+4:b+7]
    
def decode(i):
    """
    HMR2300デバイスのアスキー出力データをX,Y,Z成分の数値に変換する
    CR抜きで27文字以外だとエラー
    return: X,Y,Z成分の値リスト
    """
#    print len(i)
    i = i.translate(None,'\r\n')
#    print len(i)
    if len(i) != 27:
        print __name__ + " ERR len=" + len(i)
        return 0,0,0
    # X
    s = _decode_sub(0,i)
#    print s
    x = int(s)
#    print x
    # Y
    s = _decode_sub(9,i)
#    print s
    y = int(s)
#    print y
    # Z
    s = _decode_sub(18,i)
#    print s
    z = int(s)
#    print z
    return x,y,z
    
