#!/usr/bin/env python
# coding:UTF-8
#
# PiLog Library
#
"""
PiLog基本ライブラリ

デバイスに依存しない関数群
シリアル関連関数
ファイル関連関数
"""
__author__ = 'ntaka'
__version__ = '0.1'

import serial
import os.path

# End of lineのデフォルト値
eol='\n'

def _readline(self):
    """
    改行コードでシリアル受信データの1行を区切る
    eol変数にセットした改行コードを使う
    """
    leneol = len(eol)
    line = bytearray()
    while True:
        c = self.read(1)
        if c:
            line += c
            if line[-leneol:] == eol:
                break
        else:
            break
    return bytes(line)

def cmdsend(port, cmd):
    """
    デバイスにシリアルコマンドを送る
    eol変数にセットした改行コードを末尾に付けて送信する
    """
    try:
        port.write(cmd + eol)
        port.flush
    except:
        print "ERR: serial.write()"

def resrcv(port):
    """
    デバイスからシリアルレスポンス1行を受信する
    eol変数にセットした改行コードを使う
    """
    try:
        rcv = _readline(port)
        print("rcv:" + repr(rcv))
        return rcv
    except:
        print "ERR: serial._readline()"
        return ''


def fileout(recdir, fname, tstamp, data):
    """
    テキスト形式の測定データをファイルに書き込む
    csv形式で書き込む。staampとdataをカンマで結合して改行コードを末尾に付加して書き込む。
    改行コードはLF固定
    tstamp: タイムスタンプ文字列
    data: 測定データ文字列
    """
    try:
        if not os.path.isdir(recdir):
            os.makedirs(recdir)
    except:
        print "ERR: makedirs()"
    finally:
        pass
    with open(recdir + '/' + fname, 'a') as f:
        f.write(tstamp + "," + data + "\n")
#        data = data.translate(None,'\r\n')
#        f.write(tstamp + "," + repr(data) + "\n")
        f.close
       
