AS_INIT

# $Id: m6888x-auto.sh,v 1.2 2007/08/25 20:41:10 fredette Exp $

# ic/m6888x-auto.sh - automatically generates C code for many m6888x
# emulation instructions:

#
# Copyright (c) 2004 Matt Fredette
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. All advertising materials mentioning features or use of this software
#    must display the following acknowledgement:
#      This product includes software developed by Matt Fredette.
# 4. The name of the author may not be used to endorse or promote products
#    derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
# INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
# STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
# ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#

header=false

for option
do
    case $option in
    --header) header=true ;;
    esac
done

PROG=`basename $0`
cat <<EOF
/* automatically generated by $PROG, do not edit! */
_TME_RCSID("\$Id: m6888x-auto.sh,v 1.2 2007/08/25 20:41:10 fredette Exp $");

EOF

# placeholder for a permutation over FPU types:
#
fpu=m6888x

    # generate the FPgen opmode bitmap and table:
    #
    for what in bitmap table; do

	# when we're doing the m68040, we only make the bitmap:
	#
	if test ${fpu} = m68040 && test ${what} != bitmap; then
	    continue
	fi

	# dispatch on the what:
	#
	case ${what} in

	bitmap)
	    cat <<EOF

/* the ${fpu} FPgen opmode bitmap: */
const tme_uint8_t _tme_${fpu}_fpgen_opmode_bitmap[[128 / 8]] = {
EOF

	# reset the bitmap:
	#
	opmode_bitmap=0
	opmode_bit=1
	$as_echo_n "  "
	;;

	table)
	    cat <<EOF

/* the ${fpu} FPgen opmode table: */
static const struct tme_m6888x_fpgen _tme_${fpu}_fpgen_opmode_table[[128]] = {
EOF
	    ;;
	esac
    
	# loop over the FPgen opmodes:
	#
	opmode=-1
	while test ${opmode} != 127; do
	    opmode=`expr \( ${opmode} \) + 1`

	    # if we're generating the opmode bitmap, and this opmode
	    # is in a new byte, emit the previous byte and reset for
	    # this byte:
	    #
	    if test ${what} = bitmap && test ${opmode_bit} = 256; then
		$as_echo_n "${opmode_bitmap}, "
		opmode_bitmap=0
		opmode_bit=1
	    fi

	    # characterize this opmode:
	    #
	    name=''
	    optype=MONADIC
	    rounding_precision=CTL
	    rounding_mode=NULL
	    fpu_types=TME_M68K_FPU_ANY
	    name_ieee754=x
	    case "${opmode}" in

	    # fabs pp 305:
	    #
	    24) name=abs ;;
	    88) name=abs ; rounding_precision=SINGLE ; fpu_types=TME_M68K_FPU_M68040 ;;
	    92) name=abs ; rounding_precision=DOUBLE ; fpu_types=TME_M68K_FPU_M68040 ;;

	    28) name=acos ; fpu_types='TME_M68K_FPU_M6888X' ;;	# facos pp 309

	    # fadd pp 312:
	    #
	    34) name=add ; optype=SRC_DST ;;
	    98) name=add ; optype=SRC_DST ; rounding_precision=SINGLE ; fpu_types=TME_M68K_FPU_M68040 ;;
	    102) name=add ; optype=SRC_DST ; rounding_precision=DOUBLE ; fpu_types=TME_M68K_FPU_M68040 ;;

	    12) name=asin ; fpu_types=TME_M68K_FPU_M6888X ;;	# fasin pp 315
	    10) name=atan ; fpu_types=TME_M68K_FPU_M6888X ;;	# fatan pp 318
	    13) name=atanh ; fpu_types=TME_M68K_FPU_M6888X ;;	# fatanh pp 321
	    56) name=cmp ; name_ieee754= ; optype=DST_SRC ;;	# fcmp pp 326
	    29) name=cos ; fpu_types=TME_M68K_FPU_M6888X ;;	# fcos pp 329
	    25) name=cosh ; fpu_types=TME_M68K_FPU_M6888X ;;	# fcosh pp 332

	    # fdiv pp 337:
	    #
	    32) name=div ; optype=DST_SRC ;;
	    96) name=div ; optype=DST_SRC ; rounding_precision=SINGLE ; fpu_types=TME_M68K_FPU_M68040 ;;
	    100) name=div ; optype=DST_SRC ; rounding_precision=DOUBLE ; fpu_types=TME_M68K_FPU_M68040 ;;
	
	    16) name=etox ; name_ieee754=exp ; fpu_types=TME_M68K_FPU_M6888X ;;	# fetox pp 341
	    8) name=etoxm1 ; name_ieee754=expm1 ; fpu_types=TME_M68K_FPU_M6888X ;;	# fetoxm1 pp 344
	    30) name=getexp ; fpu_types=TME_M68K_FPU_M6888X ;;	# fgetexp pp 347
	    31) name=getman ; fpu_types=TME_M68K_FPU_M6888X ;;	# fgetman pp 350
	    1) name=int ; name_ieee754=rint ; fpu_types=TME_M68K_FPU_M6888X ;;	# fint pp 353
	    3) name=intrz ; name_ieee754=rint ; rounding_mode=TO_ZERO ; fpu_types=TME_M68K_FPU_M6888X ;; # fintrz pp 356
	    21) name=log10 ; fpu_types=TME_M68K_FPU_M6888X ;;	# flog10 pp 359
	    22) name=log2 ; name_ieee754= ; fpu_types=TME_M68K_FPU_M6888X ;;	# flog2 pp 362
	    20) name=logn ; name_ieee754=log ; fpu_types=TME_M68K_FPU_M6888X ;;	# flogn pp 365
	    6) name=lognp1 ; name_ieee754=log1p ; fpu_types=TME_M68K_FPU_M6888X ;;	# flognp1 pp 368
	    33) name=mod ; name_ieee754= ; fpu_types=TME_M68K_FPU_M6888X ; optype=DST_SRC ;;	# fmod pp 371

	    # fmove pp 374:
	    #
	    0) name=move ;;
	    64) name=move ; rounding_precision=SINGLE ; fpu_types=TME_M68K_FPU_M68040 ;;
	    68) name=move ; rounding_precision=DOUBLE ; fpu_types=TME_M68K_FPU_M68040 ;;

	    # fmul pp 395:
	    #
	    35) name=mul ; optype=SRC_DST ;;
	    99) name=mul ; optype=SRC_DST ; rounding_precision=SINGLE ; fpu_types=TME_M68K_FPU_M68040 ;;
	    103) name=mul ; optype=SRC_DST ; rounding_precision=DOUBLE ; fpu_types=TME_M68K_FPU_M68040 ;;

	    # fneg pp 399:
	    #
	    26) name=neg ;;
	    90) name=neg ; rounding_precision=SINGLE ; fpu_types=TME_M68K_FPU_M68040 ;;
	    94) name=neg ; rounding_precision=DOUBLE ; fpu_types=TME_M68K_FPU_M68040 ;;
	
	    37) name=rem ; name_ieee754= ; optype=DST_SRC ; fpu_types=TME_M68K_FPU_M6888X ;;	# frem pp 405
	    38) name=scale ; optype=DST_SRC ; fpu_types=TME_M68K_FPU_M6888X ;;	# fscale pp 408
	    36) name=sgldiv ; name_ieee754= ; optype=DST_SRC ;;	# fsgldiv pp 413
	    39) name=sglmul ; name_ieee754= ; optype=DST_SRC ;;	# fsglmul pp 416
	    14) name=sin ;;		# fsin pp 419

	    48|49|50|51|52|53|54|55) name=sincos ; fpu_types=TME_M68K_FPU_M6888X ; name_ieee754= ;;	# fsincos pp 422
	    2) name=sinh ; fpu_types=TME_M68K_FPU_M6888X ;;		# fsinh pp 426

	    # fsqrt pp 429:
	    #
	    4) name=sqrt ;;
	    65) name=sqrt ; rounding_precision=SINGLE ; fpu_types=TME_M68K_FPU_M68040 ;;
	    69) name=sqrt ; rounding_precision=DOUBLE ; fpu_types=TME_M68K_FPU_M68040 ;;

	    # fsub pp 433:
	    #
	    40) name=sub ; optype=DST_SRC ;;
	    104) name=sub ; optype=DST_SRC ; rounding_precision=SINGLE ; fpu_types=TME_M68K_FPU_M68040 ;;
	    108) name=sub ; optype=DST_SRC ; rounding_precision=DOUBLE ; fpu_types=TME_M68K_FPU_M68040 ;;

	    15) name=tan ; fpu_types=TME_M68K_FPU_M6888X ;;		# ftan pp 437
	    9) name=tanh ; fpu_types=TME_M68K_FPU_M6888X ;;		# ftanh pp 440
	    18) name=tentox ; name_ieee754= ; fpu_types=TME_M68K_FPU_M6888X ;;	# ftentox pp 443
	    58) name=tst ; name_ieee754= ;;				# ftst pp 448
	    17) name=twotox ; name_ieee754= ; fpu_types=TME_M68K_FPU_M6888X ;;	# ftwotox pp 451

	    esac

	    # fix up the ieee754 name:
	    #
	    if test "x${name_ieee754}" = xx; then name_ieee754=${name}; fi

	    # dispatch on the what:
	    #
	    case ${what} in

	    bitmap)
		if test ${fpu_types} = TME_M68K_FPU_M68040 && test ${fpu} != m68040; then
		    name=
		fi
		if test "x${name}" != x; then
		    opmode_bitmap=`expr ${opmode_bitmap} + ${opmode_bit}`
		fi
		opmode_bit=`expr ${opmode_bit} \* 2`
		;;

	    table)
	    
		$as_echo ""
		$as_echo "  /* opmode ${opmode}: */"
		$as_echo_n "  { "

		# the function:
		#
		if test "x${name}" = x; then
		    $as_echo_n "NULL"
		    $as_echo_n ", 0"
		    fpu_types=TME_M68K_FPU_NONE
		elif test "x${name_ieee754}" != x; then
		    $as_echo_n "NULL"
		    $as_echo_n ", TME_M6888X_IEEE754_OP(tme_ieee754_ops_extended80_${name_ieee754})"
		else
		    $as_echo_n "_tme_m6888x_f${name}"
		    $as_echo_n ", 0"
		fi

		# the m6888x types:
		#
		$as_echo_n ", ${fpu_types}"

		# the operation type:
		#
		if test ${optype} != MONADIC; then optype="DYADIC_${optype}"; fi
		$as_echo_n ", TME_M6888X_OPTYPE_${optype}"

		# the rounding mode:
		#
		$as_echo_n ", TME_FLOAT_ROUND_${rounding_mode}"
	
		# the rounding precision:
		#
		$as_echo_n ", TME_M6888X_ROUNDING_PRECISION_${rounding_precision}"

		$as_echo " },"
		;;
	    esac
	done

	# dispatch on the what:
	#
	case ${what} in

	bitmap)
	    $as_echo "${opmode_bitmap}"
	    $as_echo "};"
	    ;;

	table)
	    $as_echo "};"
	    ;;
	esac

    done


# done:
#
exit 0
