#include "stdafx.h"
#include "appinfo.h"
#include "function.h"
#include "bugreport.h"
#include "commanage.h"

#include "namespace_start.h"


Bool BugTransfer::Report()const{

	Bool rslt = false;
	
	NString userId;
	GetnliteUserId(userId);
	nstringstream bugmessage;

	bugmessage << _T("version=") << CApplicationInfo::getProductVersion() << _T("&");
	bugmessage << _T("nliteUserId=") << userId << _T("&");
	bugmessage << _T("summary=") << summary << _T("&");
	bugmessage << _T("function=") << function << _T("&");
	bugmessage << _T("sourcefile=") << sourcefile << _T("&");
	bugmessage << _T("line=") << line << _T("&");
	bugmessage << _T("windowsErrorCode=") << windowsErrorCode << _T("&");
	bugmessage << _T("windowsErrorMessage=") << windowsErrorMessage << _T("&");
	bugmessage << _T("osVersion=") << GetWindowsVersion();


	nregex reg(_T("[\r|\n]"));
	NString message(std::regex_replace(bugmessage.str(),reg,NString(_T(""))));
	
	CWinHttpClient httpClient;
	httpClient.Open(_T("POST"),_T("http://nlite.sourceforge.jp/cgi-bin/bugreport.rb"));
	httpClient.SetRequestHeader(_T("Content-Type"),_T("application/x-www-form-urlencoded"));
	httpClient.Send(message.c_str());
	return rslt;
}


CBugReporter::CBugReporter(){


}

CBugReporter::~CBugReporter(){

	this->m_threadgroup.join_all();

}

Void CBugReporter::Report(const BugTransfer& bug){


	
	
	m_threadgroup.create_thread([
		bug](Void) -> Bool { 
			CComManage commanage;
			return bug.Report(); 
		});

	return;
}

#include "namespace_end.h"