#pragma once

#include <Windows.h>

#include "unit_test.h"
#include "define.h"
#include "raii.h"

#include "namespace_start.h"



class CHResult{
	friend Bool operator==(const CHResult &result,HRESULT hResult);
	friend Bool operator==(HRESULT hResult,const CHResult &result);
	friend Void UnitTest();
private:
	HRESULT m_hResult;
	
	///
	///RXgN^
	///
public:
	CHResult();

	CHResult(HRESULT hResult);

	HRESULT operator=(HRESULT hResult);

	operator HRESULT()const;

	Bool IsS_OK()const;

	Bool IsSucceded()const;

	Bool IsFailed()const;


	

};
extern Bool operator==(const CHResult &result,HRESULT hResult);

extern Bool operator==(HRESULT hResult,const CHResult &result);

static_assert(sizeof(CHResult) <= 4,"CHResult size error");




///
///WXgL[NX
///
class CRegistryKey:public RAIIT<CRegistryKey,HKEY>{

public:
	typedef std::vector<Byte> ValueList;
	Void Dispose();

	CHResult OpenKey(HKEY hkey,const NString &subKeystr,DWORD options = 0,REGSAM samDesired = KEY_READ);


	CHResult QueryValue(const NString &valueName,NString &val,LPDWORD lpType = nullptr,LPDWORD lpReserved = nullptr);

	CHResult QueryValue(const NString &valueName,Int &val,LPDWORD lpType = nullptr,LPDWORD lpReserved = nullptr);
private:

	CHResult QueryValue(const NString &valueName,ValueList &valueList,LPDWORD lpType = nullptr,LPDWORD lpReserved = nullptr);


	operator HKEY();

};



///
///t@Cht@[Xgt@C
///
class CFindFirstFile:public RAIIT<CFindFirstFile,HANDLE>{


public:
	Void Dispose();

	Bool NextFile(WIN32_FIND_DATA &findData);

	HANDLE Find(const NString &fileName,WIN32_FIND_DATA &findData);


};


///
///OSo[W擾
///
extern const NString &GetWindowsVersion();


extern VOID GetWindowsErrorMessage(NString &buf,DWORD lastErrorCode);

extern Bool NCopyFile(const NString &existingFileName, const NString &newFileName, Bool bFailIfExists = false);

extern Bool NDeleteFile(const NString &fileName);

///
///ϐ擾
///
extern Bool GetAppLocalDataDirectry(NString &dir);

extern Bool GetAppDataDirectry(NString &dir);

extern Bool GetCookieDirectry(NString &dir);

extern Bool GetTempDirectry(NString &dir);


#include "namespace_end.h"


#pragma comment(lib,"Shell32.lib")

