#pragma once

#include <tchar.h>
#include <nlite_common\define.h>
#include <nlite_common\function.h>



#include "namespace_start.h"
class CCopyCookieFile{

	NString filePath;

public:
	CCopyCookieFile(const NString &filePath){
			
		CookieFileCopyTemp(filePath,this->filePath);
	
	}

	~CCopyCookieFile(){

		NDeleteFile(filePath);
	}

	const NString &GetFilePath(){

		return filePath;
	}


	static Bool CookieFileCopyTemp(const NString &cookieFilePath,NString &newFileName){

		Bool result = false;
		NString tempStr;
		GetTempDirectry(tempStr);

		CTm tmt;

		tmt.SetNowLocalTime();

		NString timeStr;

		FormatTime(timeStr,_T("%Y%m%d%H%M%S"),tmt);

		tempStr += _T("\\");
		tempStr += timeStr;

		result = NCopyFile(cookieFilePath,tempStr);

		if(result){

			newFileName = tempStr;

		}

		return result;

	}

};

#include "namespace_end.h"