#include <Windows.h>
#include <boost\utility.hpp>
#include "sqlitemanage.h"
#include <iostream>
#include <nlite_common\function.h>
#include "namespace_start.h"


Int CDB::Open(const U16String& path,Int flags,const Char *vfs){

	MString mPath;
	ToUTF8(mPath,path);
	Int rc = sqlite3_open_v2(mPath.c_str(),&m_handle,flags,vfs);
	if ( SQLITE_OK != rc )  {
		Dispose();
		goto end;
	}

	sqlite3_busy_timeout(m_handle,2000);
end:

	return rc;
	
}

Int CDB::Prepare(const U16String& sql,CStatement &stmt,const Void ** tail){

	Int rc = SQLITE_ERROR;
	if(stmt.m_handle == nullptr){
		rc = sqlite3_prepare16_v2(m_handle,sql.c_str(),-1,&stmt.m_handle,tail);

		if(rc != SQLITE_OK){

			stmt.Dispose();

		}
	}

	return rc;

}

Void CDB::Dispose(){
	sqlite3_stmt *stmt = nullptr, *next = nullptr;
	

	if(m_handle != nullptr){
		if ( sqlite3_close( m_handle ) != SQLITE_OK )  { 

	
			stmt = sqlite3_next_stmt( m_handle, next ); 
			while( NULL != stmt )  {
				next = sqlite3_next_stmt( m_handle, stmt ); 
				sqlite3_finalize( stmt );			

				stmt = next;
			}
			sqlite3_close( m_handle );

		
		}
		m_handle = nullptr;
	}
}









//
//Xe[gg
////////////////////////////////////////


Int CStatement::Step(){

	Int rc;
	Int count = 0;
	do{
		
		rc =  sqlite3_step( m_handle );
		++count;

		if(SQLITE_BUSY != rc && SQLITE_LOCKED != rc)break;

		::Sleep(1000);
	}while(  count < 3);

	return rc;
}

const CharU16* CStatement::Column(Int no){
	
	return reinterpret_cast <const CharU16*>(sqlite3_column_text16(m_handle,no));
}

Int CStatement::Bind(Int no,const U16String &text,Void(*destractor)(Void*)){

	return sqlite3_bind_text16(m_handle,no,text.c_str(),-1,destractor);
}

Void CStatement::Dispose(){

	sqlite3_finalize(m_handle);

	m_handle = nullptr;

	return;
}


#include "namespace_end.h"