#pragma once
#include "nlite_propertyWindow.h"
namespace nlite{

	class CProperty;
	class CReadPropertyXML;
	///
	///Rgr[ݒ
	///
	class CCommentViewProperty{
		friend CProperty;
		friend CReadPropertyXML;
		enum CommentTimeType{
			WriteTimeType,
			StreamingTimeType

		};

	
	

	private:
		INT_PTR headerholSize[COMMENTVIEW_HEADERITEMSIZE];			//wb_TCY
		INT_PTR headerOrderArray[COMMENTVIEW_HEADERITEMSIZE];		//wb_яz
		BOOL commentFoldingFlag;									//Rg܂肽݃tO
		UINT_PTR commentTimeType;									//Rgԕ\^Cv
		COLORREF backColor;											//̔wiF
		COLORREF selectBackColor;									//I̔wiF
		COLORREF selectSellLineColor;								//I̘g
		COLORREF normalSellLineColor;								//ʏ펞̘g
		COLORREF baseStringColor;									//̕F
		COLORREF ownerStringColor;									//^cF
		COLORREF linkStringColor;									//̃nCp[N̐F
		COLORREF anonymousIDLinkColor;								//ID\F
		COLORREF colLineColor;										//ڂ̏c


	public:
		///
		///RXgN^
		///
		CCommentViewProperty();


		//Qb^[
	public:
		COLORREF GetOwnerStringColor()const;

		COLORREF GetBaseStringColor()const;

		COLORREF GetSelectBackColor()const;

		COLORREF GetSelectSellLineColor()const;

		COLORREF GetBackColor()const;

		COLORREF GetNormalLineColor()const;

		COLORREF GetLinkStringColor()const;

		COLORREF GetColLineColor()const;

		BOOL IsCommentFoldingFlag()const;

		INT_PTR *GetHeaderHolSize();

		INT_PTR *GetHeaderOrderArray();

		UINT_PTR GetHeaderOrderArrayLength()const;
	};

	///
	///Rgǂݏグݒ
	///
	class CCommentReadProperty{
		friend CReadPropertyXML;
		friend CProperty;
	private:

		BOOL commentReadFlag;								//RgǂݏグtO
		BOOL ngWordReadFlag;								//NG[hǂݏグtO
		BOOL ngUserReadFlag;								//NG[U[ǂݏグtO
		BOOL administratorCommentReadFlag;					//^cRgǂݏグtO
		BOOL bspReadFlag;									//obNXe[WpXǂݏグtO
		BOOL userCommentReadFlag;							//[U[RgǂݏグtO
		BOOL teropReadFlag;									//ebvǂݏグtO
		BOOL newLineReadFlag;								//sǂݏグtO
		BOOL besideLengthFlag;								//ǂݏグTCYtO
		UINT_PTR maxCommentLength;							//ǂݏグTCYݒ莞̍őTCY
		CNLiteString shortComment;							//ȗɓǂݏグ镶
		CNLiteString outString;								//ǂݏグO
		
	public:
		///
		///RXgN^
		///
		CCommentReadProperty();

		//Zb^[
	public:
		VOID SetCommentRead(BOOL flag);

		//Qb^[
	public:
		///
		///RgǂݏグtO擾
		///
		BOOL IsCommentRead()const;

	};

	///
	///ʐݒ
	///
	class CGeneralProperty{
		friend CProperty;
		friend CReadPropertyXML;
	private:
		CNLiteString browserPath;					//uEŨpX
		BOOL userCountUpdateFlag;					//ҐXV邩̃tO
		BOOL commentLogAutoSaveFlag;				//Rgۑp̃tO
		CNLiteString commentPath;					//RgOۑꏊ
		BOOL defaultBrowserFlag;					//NJۂɊ̃uEUgp邩̃tO
		BOOL autoNameRegisterFlag;					//[Uo^tO
		BOOL autoNameUpdateFlag;					//XVĎo^tO
		BOOL numberNameFlag;						//݂̖̂O邩̃tO
		BOOL  autoColorRegisterFlag;				//Oo^ɐFIɎw肷邩̃tO
		BOOL activeCountTimeFlag;					//ANeBulXV邩̃tO
		BROWSERTYPE browserType;					//uEU^Cv
		BOOL ncvUserSettingReadedFlag;				//ncvXi[f[^ǂݍݍς݃tO
		

	public:
		///
		///RXgN^
		///
		CGeneralProperty();


		//Zb^[
	public:
		VOID SetNCVUSerSettingReaded(BOOL flag);

		//Qb^[
	public:
		///
		///ncvXi[f[^ǂݍ݃tO
		///
		BOOL IsNCVUserSettingReaded()const;
		
		BOOL IsNumberName()const;

		///
		///uEU^Cv擾
		///
		BROWSERTYPE GetBrowserType()const;

		///
		///uEUpX擾
		///
		const CNLiteString &GetBrowserPath()const;
	};
	

	///
	///Cݒ
	///
	class CMainFrameProperty{
		friend CReadPropertyXML;
		friend CProperty;
	private:

		SIZE windowSize;							//EBhETCY
		BOOL windowFrontFlag;						//EBhEőOʕ\tO


	public:
		///
		///RXgN^
		///
		CMainFrameProperty();
		

		//Zb^[
	public:
		VOID SetWindowFront(BOOL flag);

		//Qb^[
	public:

		///
		///EBhETCY̎擾
		///
		const SIZE &GetWindowSize()const;
		

		///
		///EBhESʕ\tO̎擾
		///
		BOOL IsWindowFront()const;

	};

	///
	///nliteݒ
	///
	class CProperty{
		friend CReadPropertyXML;
	private:
		CCommentViewProperty cvp;					//Rgr[vpeB
		CMainFrameProperty mfp;						//CEBhEvpeB
		CGeneralProperty gp;							//LvpeB
		CCommentReadProperty crp;					//RgǂݏグvpeB
		CNLiteString appLocalPath;					//[JtH_pX
		CNLiteString propertyFolderPath;			//vpeBzuLڂꂽtH_
		CNLiteString propertySaveFolderPath;		//vpeBf[^ۑtH_
		CNLiteString propertyPath;					//vpeBt@CpX
		CNLiteString listenerDataPath;				//Xi[ݒt@CpX
		CNLiteString qwerty_nicoPath;
		const static CNLiteString iniFileName;

	public:
		CProperty();

		~CProperty();

		

	private:
		VOID CreatePropertyFile();

		VOID WritePropertySaveFile();

	public:
		VOID Initialize();

		VOID ReadProperty();


		VOID WriteProperty();

		BROWSERTYPE CookieSetting();

		//Zb^[
	public:
		VOID SetCommentViewProperty(const CCommentViewProperty& commentViewProperty);
		
		//Qb^[

	public:
		CCommentViewProperty &GetCommentViewProperty();

		CMainFrameProperty &GetMainFrameProperty();

		CGeneralProperty &GetGeneralProperty();

		CCommentReadProperty &GetCommentReadProperty();


		const CNLiteString &GetListenerDataPath()const;

		const CNLiteString &GetPropertySaveFolderPath()const;

		const CNLiteString &Getqwerty_nicoPath()const;
	};


	///
	///ݒt@CxmlǂݎpNX
	///
	class CReadPropertyXML:public CXmlParser{

	private:

		CProperty &nliteProperty;

		struct Node{

			enum type{
				None,
				CCommentReadProperty,
				CCommentViewProperty,
				CMainFrameProperty,
				CGeneralProperty
			};
		};

		
		Node::type propertyType;			//vpeB̃^Cv
		tstring nodeName;					//m[h



	public:
		///
		///RXgN^
		///
		CReadPropertyXML(CProperty &in_property);



		void OnStartElement (const XML_Char *pszName, const XML_Char **papszAttrs);

		void OnEndElement (const XML_Char *pszName);

		void OnCharacterData (const XML_Char *pszData, int nLength);
	};


	


}