/* ----------------------------------------------------------------- */
/*           The HMM-Based Speech Synthesis System (HTS)             */
/*           Open JTalk developed by HTS Working Group               */
/*           http://open-jtalk.sourceforge.net/                      */
/* ----------------------------------------------------------------- */
/*                                                                   */
/*  Copyright (c) 2008-2010  Nagoya Institute of Technology          */
/*                           Department of Computer Science          */
/*                                                                   */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/* - Redistributions of source code must retain the above copyright  */
/*   notice, this list of conditions and the following disclaimer.   */
/* - Redistributions in binary form must reproduce the above         */
/*   copyright notice, this list of conditions and the following     */
/*   disclaimer in the documentation and/or other materials provided */
/*   with the distribution.                                          */
/* - Neither the name of the HTS working group nor the names of its  */
/*   contributors may be used to endorse or promote products derived */
/*   from this software without specific prior written permission.   */
/*                                                                   */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND            */
/* CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,       */
/* INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF          */
/* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE          */
/* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS */
/* BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,          */
/* EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED   */
/* TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,     */
/* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON */
/* ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,   */
/* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY    */
/* OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/* POSSIBILITY OF SUCH DAMAGE.                                       */
/* ----------------------------------------------------------------- */



#pragma once

#ifdef OPENJTALK_STATIC_MACRO

#define OPENJTALK_EXPORT extern

#else

#ifdef OPENJTALK_EXPORTS_MACRO
#define OPENJTALK_EXPORT __declspec(dllexport)
#else
#define OPENJTALK_EXPORT __declspec(dllimport)
#endif /* OPENJTALKOPENJTALK_EXPORTS */
#endif /*OPENJTALK_STATIC_MACRO*/

#include "open_jtalk\mecab\src\mecab.h"
#include "hts_engine_API\include\HTS_engine.h"
#include "open_jtalk\jpcommon\jpcommon.h"
#include "open_jtalk\njd\njd.h"
#include "open_jtalk\mecab2njd\mecab2njd.h"
#include "open_jtalk\njd_set_accent_phrase\njd_set_accent_phrase.h"
#include "open_jtalk\njd_set_accent_type\njd_set_accent_type.h"
#include "open_jtalk\njd_set_digit\njd_set_digit.h"
#include "open_jtalk\njd_set_long_vowel\njd_set_long_vowel.h"
#include "open_jtalk\njd_set_pronunciation\njd_set_pronunciation.h"
#include "open_jtalk\njd_set_unvoiced_vowel\njd_set_unvoiced_vowel.h"
#include "open_jtalk\njd2jpcommon\njd2jpcommon.h"
#include "open_jtalk\text2mecab\text2mecab.h"

typedef struct _OpenJTalk {
   Mecab mecab;
   NJD njd;
   JPCommon jpcommon;
   HTS_Engine engine;
} OpenJTalk;

#ifdef __cplusplus
extern "C"{
#endif

OPENJTALK_EXPORT void OpenJTalk_initialize(OpenJTalk * open_jtalk, HTS_Boolean use_lpf, int sampling_rate,
                          int fperiod, double alpha, int stage, double beta, int audio_buff_size,
                          double uv_threshold, HTS_Boolean use_log_gain, double gv_weight_mgc,
                          double gv_weight_lf0, double gv_weight_lpf);

OPENJTALK_EXPORT void OpenJTalk_load(OpenJTalk * open_jtalk, char *dn_mecab, char *fn_ms_dur, char *fn_ts_dur,
                    char *fn_ms_mgc, char *fn_ts_mgc, char **fn_ws_mgc, int num_ws_mgc,
                    char *fn_ms_lf0, char *fn_ts_lf0, char **fn_ws_lf0, int num_ws_lf0,
                    char *fn_ms_lpf, char *fn_ts_lpf, char **fn_ws_lpf, int num_ws_lpf,
                    char *fn_ms_gvm, char *fn_ts_gvm, char *fn_ms_gvl, char *fn_ts_gvl,
                    char *fn_ms_gvf, char *fn_ts_gvf, char *fn_gv_switch);

OPENJTALK_EXPORT void OpenJTalk_synthesis(OpenJTalk * open_jtalk, char *txt, FILE * wavfp, FILE * logfp);


OPENJTALK_EXPORT void OpenJTalk_clear(OpenJTalk * open_jtalk);


#ifdef __cplusplus
}
#endif