
#include "..\..\00_HeaderFiles\00_ManagementClasses\CSceneManager.h"

#include "..\..\00_HeaderFiles\02_DerivedClasses\Scenes\CTitleScene.h"
#include "..\..\00_HeaderFiles\02_DerivedClasses\Scenes\CConquestScene.h"
#include "..\..\00_HeaderFiles\02_DerivedClasses\Scenes\CTerminalScene.h"

CSceneManager::CSceneManager( void )
{
	// x悤ƂƂ̓vOIB
	static bool bFirstGeneration = true;
	if ( bFirstGeneration )
	{
		// ͂̃XR[vɋLqB
		m_eCurrentSceneType = ESceneType::TITLE;
		m_pinCurrentScene = new CTitleScene();
		
		bFirstGeneration = false;
		return;
	}
	
	MessageBox( NULL,
	            "CSceneManagerNXx悤Ƃ܂B",
	            "",
	            MB_OK );
	
	assert( false );
}

void CSceneManager::Run( CImageManager* arg_pinImageManager,
                         CAllKeysState* arg_pinAllKeysState )
{
	// ݎs̃V[NXɐݒ肳ĂV[ύX̗v]
	// ₢킹ASetScene֐Őݒ肷B
	// iV[NXV[ǗNXɃANZX
	//   ˑ֌WŕGɂȂ邽߁j
	ESceneType e = m_pinCurrentScene->GetRequestScene();
	if ( e != ESceneType::TOTAL )
	{
		SetScene( e );
	}
	
	m_pinCurrentScene->Run( arg_pinImageManager, arg_pinAllKeysState );
}

void CSceneManager::SetScene( ESceneType arg_eNewSceneType )
{
	// ݂̃V[^CvύXB
	m_eCurrentSceneType = arg_eNewSceneType;
	
	// ݂̃V[폜ĐݒB
	delete m_pinCurrentScene;

	switch( arg_eNewSceneType ) {
	case ESceneType::TITLE :
		m_pinCurrentScene = new CTitleScene();
		break;
		
	case ESceneType::CONQUEST :
		m_pinCurrentScene = new CConquestScene();
		break;
		
	case ESceneType::TERMINAL :
		m_pinCurrentScene = new CTerminalScene();
		break;
	}
}


