
#include "..\..\00_HeaderFiles\00_ManagementClasses\CMapCellManager.h"
#include "..\..\00_HeaderFiles\00_ManagementClasses\CImageManager.h"

#include "..\..\00_HeaderFiles\03_OtherClasses\CMapCell.h"

CMapCellManager::CMapCellManager( void )
{
	m_iCurrentMapCell = 0;
	
	// }bvZi[
	for ( int i = 0; i < MAPCELL_TOTAL ; i++ )
	{
		CMapCell tmp( MAP_STATUS[ i ] );
		m_vinMapCell.push_back( tmp );
	}
}

CMapCellManager::~CMapCellManager( void )
{
}

void CMapCellManager::Run( CImageManager* arg_pinImageManager,
                           CAllKeysState* arg_pinAllKeysState )
{
	m_vinMapCell[ m_iCurrentMapCell ].Run( arg_pinImageManager,
	                                       arg_pinAllKeysState );
	
}

CMapCellManager::EMapObjectType CMapCellManager::GetMapCellDataByGrid( 
	                                     int arg_iBase_X_ByGrid,
	                                     int arg_iBase_Y_ByGrid,
	                                     int arg_iVariation_X_ByGrid,
	                                     int arg_iVariation_Y_ByGrid
	                                   )
{
	EMapObjectType e = m_vinMapCell[ m_iCurrentMapCell ].GetMapCellDataByGrid(
	                                                     arg_iBase_X_ByGrid,
	                                                     arg_iBase_Y_ByGrid,
	                                                     arg_iVariation_X_ByGrid,
	                                                     arg_iVariation_Y_ByGrid);
	
	return e;
}

void CMapCellManager::SwitchMapCell( ESwitchType arg_eSwitchType )
{
	if ( ESwitchType::TOP == arg_eSwitchType )
	{
		m_iCurrentMapCell--;
		if ( m_iCurrentMapCell <= -1 )
		{
			MessageBox( NULL, "݂Ȃ}bvZɈړ悤Ƃ܂B",
			            "YABAI", MB_OK );
			assert( false );
		}
	}
	else if ( ESwitchType::UNDER == arg_eSwitchType )
	{
		m_iCurrentMapCell++;
		if ( m_iCurrentMapCell >= MAPCELL_TOTAL )
		{
			MessageBox( NULL, "݂Ȃ}bvZɈړ悤Ƃ܂B",
			            "YABAI", MB_OK );
			assert( false );
		}
	}
}


int CMapCellManager::PixelToMapGrid( const int arg_pixel ) const
{
	// ؂ȂꍇALN^[肦Ȃʒuɂ\ij
	if ( ( arg_pixel % CMapCellManager::MAP_CHIP_LENGTH) != 0 )
	{
		MessageBox( NULL, "CCharacterBaseNX\n"
		                  "PixelToMapGrido֐ňُ킪܂B\n\n"
		                  "LN^[݂̌̍W60Ŋ낤Ƃ܂\n"
		                  "肫܂łB"
		                  "قڊԈႢȂoOɂȂƎv܂B",
		            "YABAI", MB_OK );
	}

	return ( arg_pixel / CMapCellManager::MAP_CHIP_LENGTH );
}

const int CMapCellManager::MAP_STATUS[ MAPCELL_TOTAL ]
                                     [ TOTAL_ROW ]
                                     [ TOTAL_COLUMN ] = {
	{
		{ 0, 0, 0, 0, 0, 0, 0, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 0, 1, 1, 1, 1, 0 },
		{ 0, 1, 0, 1, 1, 1, 1, 0 },
		{ 0, 1, 0, 1, 1, 1, 1, 1 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 1, 1, 1, 0, 1, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 0, 0, 1, 1, 0, 0, 0 },
	},
	{
		{ 0, 0, 0, 1, 1, 0, 0, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 0, 1, 1, 0, 1, 0 },
		{ 0, 1, 0, 0, 1, 0, 1, 0 },
		{ 0, 1, 0, 1, 1, 0, 0, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 0, 1, 0, 0, 1, 0 },
		{ 0, 1, 1, 1, 1, 0, 1, 0 },
		{ 0, 0, 0, 1, 1, 0, 0, 0 },
	},
	{
		{ 0, 0, 0, 1, 1, 0, 0, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 0, 0, 1, 0, 1, 0 },
		{ 0, 1, 0, 1, 1, 1, 0, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 0, 1, 1, 0, 1, 0 },
		{ 0, 1, 0, 0, 1, 0, 1, 0 },
		{ 0, 0, 0, 1, 1, 0, 0, 0 },
	},
	{
		{ 0, 0, 0, 1, 1, 0, 0, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 0, 0, 1, 1, 1, 0 },
		{ 0, 1, 0, 0, 0, 0, 1, 0 },
		{ 0, 1, 0, 1, 1, 0, 0, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 0, 1, 1, 0, 1, 0 },
		{ 0, 1, 1, 1, 0, 1, 1, 0 },
		{ 0, 0, 0, 1, 1, 0, 0, 0 },
	},
	{
		{ 0, 0, 0, 1, 1, 0, 0, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 0, 0, 1, 0, 1, 0 },
		{ 0, 1, 0, 0, 0, 0, 0, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 0, 1, 1, 0, 1, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 0, 0, 1, 1, 0, 0, 0 },
	},
	{
		{ 0, 0, 0, 1, 1, 0, 0, 0 },
		{ 0, 0, 1, 1, 1, 1, 1, 0 },
		{ 0, 0, 0, 1, 1, 1, 1, 0 },
		{ 0, 0, 0, 0, 1, 0, 0, 0 },
		{ 0, 1, 0, 1, 1, 1, 0, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 0, 1, 1, 0, 1, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 0, 0, 1, 1, 0, 0, 0 },
	},
	{
		{ 0, 0, 0, 1, 1, 0, 0, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 0, 0, 1, 0, 1, 0 },
		{ 0, 1, 0, 1, 1, 1, 0, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 0, 1, 1, 0, 1, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 0, 0, 1, 1, 0, 0, 0 },
	},
	{
		{ 0, 0, 0, 1, 1, 0, 0, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 0, 1, 1, 1, 1, 0 },
		{ 0, 1, 0, 0, 1, 0, 1, 0 },
		{ 0, 1, 0, 1, 1, 1, 0, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 0, 1, 1, 0, 1, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 0, 0, 1, 1, 0, 0, 0 },
	},
	{
		{ 0, 0, 0, 1, 1, 0, 0, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 0, 0, 1, 0, 1, 0 },
		{ 0, 1, 0, 1, 1, 1, 0, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 0, 1, 1, 0, 1, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 0, 0, 1, 1, 0, 0, 0 },
	},
	{
		{ 0, 0, 0, 1, 1, 0, 0, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 0, 1, 1, 1, 1, 0 },
		{ 0, 1, 0, 0, 1, 0, 1, 0 },
		{ 0, 1, 0, 1, 1, 1, 0, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 0, 1, 1, 0, 1, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 0, 0, 1, 1, 0, 0, 0 },
	},
	{
		{ 0, 0, 0, 1, 1, 0, 0, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 0, 0, 1, 0, 1, 0 },
		{ 0, 1, 0, 1, 1, 1, 0, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 0, 1, 1, 0, 1, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 0, 0, 1, 1, 0, 0, 0 },
	},
	{
		{ 0, 0, 0, 1, 1, 0, 0, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 0, 1, 1, 1, 1, 0 },
		{ 0, 1, 0, 0, 1, 0, 1, 0 },
		{ 0, 1, 0, 1, 1, 1, 0, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 0, 1, 1, 0, 1, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 0, 0, 1, 1, 0, 0, 0 },
	},
	{
		{ 0, 0, 0, 1, 1, 0, 0, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 0, 0, 1, 0, 1, 0 },
		{ 0, 1, 0, 1, 1, 1, 0, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 0, 1, 1, 0, 1, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 0, 0, 1, 1, 0, 0, 0 },
	},
	{
		{ 0, 0, 0, 1, 1, 0, 0, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 0, 1, 1, 1, 1, 0 },
		{ 0, 1, 0, 0, 1, 0, 1, 0 },
		{ 0, 1, 0, 1, 1, 1, 0, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 0, 1, 1, 0, 1, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 0, 0, 1, 1, 0, 0, 0 },
	},
	{
		{ 0, 0, 0, 1, 1, 0, 0, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 1, 1, 0, 1, 1, 0 },
		{ 0, 1, 0, 0, 0, 0, 1, 0 },
		{ 0, 1, 0, 1, 1, 1, 0, 0 },
		{ 0, 1, 1, 1, 0, 1, 1, 0 },
		{ 0, 1, 0, 0, 0, 0, 1, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 0, 0, 1, 1, 0, 0, 0 },
	},
	{
		{ 0, 0, 0, 1, 1, 0, 0, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 0, 1, 1, 1, 1, 0 },
		{ 0, 1, 0, 0, 1, 0, 1, 0 },
		{ 0, 1, 0, 1, 1, 1, 0, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 0, 1, 1, 0, 1, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 0, 0, 1, 1, 0, 0, 0 },
	},
	{
		{ 0, 0, 0, 1, 1, 0, 0, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 0, 0, 1, 0, 1, 0 },
		{ 0, 1, 0, 1, 1, 1, 0, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 0, 1, 1, 0, 1, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 0, 0, 1, 1, 0, 0, 0 },
	},
	{
		{ 0, 0, 0, 1, 1, 0, 0, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 0, 0, 1, 1, 1, 0 },
		{ 0, 1, 0, 0, 1, 0, 1, 0 },
		{ 0, 1, 0, 0, 1, 1, 0, 0 },
		{ 0, 1, 1, 1, 1, 1, 0, 0 },
		{ 0, 1, 0, 1, 1, 0, 1, 0 },
		{ 0, 1, 1, 1, 1, 0, 1, 0 },
		{ 0, 0, 0, 1, 1, 0, 0, 0 },
	},
	{
		{ 0, 0, 0, 1, 1, 0, 0, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 0, 0, 1, 0, 1, 0 },
		{ 0, 1, 0, 0, 1, 1, 0, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 0, 0, 0, 1, 0, 1, 0 },
		{ 0, 0, 1, 1, 1, 1, 1, 0 },
		{ 0, 0, 0, 1, 1, 0, 0, 0 },
	},
	{
		{ 0, 0, 0, 1, 1, 0, 0, 0 },
		{ 0, 1, 0, 1, 1, 1, 1, 0 },
		{ 0, 1, 0, 1, 1, 1, 1, 0 },
		{ 0, 0, 0, 0, 1, 0, 1, 0 },
		{ 0, 1, 0, 1, 1, 1, 0, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 1, 0, 1, 1, 0, 1, 0 },
		{ 0, 1, 1, 1, 1, 1, 1, 0 },
		{ 0, 0, 0, 0, 0, 0, 0, 0 },
	},
};


