/* SCC$rand.c#mwc0.01/26Apr1991 */
/* sort of random number generators by Joel Matthew Rees primarily for games
*  Copyright for this file assigned by the author to the public domain.
*  (Not that I consider the algorithm very well-crafted.)
*  If your jurisdiction does not allow public domain assignment, 
*  you may use the following terms (MIT template):
** [Author(s)]
** Joel Rees, from November 2007 (JMR)
** All copyrights claimed and retained by the author(s).
** [License]
** This source may be used under the following conditions:
** * This source must be provided in some reasonable manner 
**   with any object distribution or publication.
** * This license notice may not be removed or modified.
** * Any modifications made to this file and published
**   shall receive the same license.
** * The author(s) make no legal representations whatsoever
**   concerning this source and the abstractions and/or
**   implementations contained therein:
** * Each user assumes all liability and responsibility
**   concerning such use.
** * USE AT YOUR OWN RISK.
** * The author(s) assert and concur that algorithms and 
**   other abstractions are fundamentally not patentable.
** * No other conditions are asserted.
** End of copyright and license notice.
*  Modified for MS-DOS/TURBO-C March 1991
*  new OS-9/CoCo version Apr 1991
*/


#include <time.h>
#include <common.h>
#define RAND
#include "rand.h"


static uint rand = 0;

trandize()
{
  struct sgtbuf diff;
  uint t, r;

  getime(&diff);
  /* calculate seconds */
#asm
* t = ((((uint) diff.t_hour << 4) - diff.t_hour) << 2) + diff.t_minute;
 clra
 ldb 7,s
 aslb
 aslb
 aslb
 asld 1
 subb 7,s
 sbca #0
 asld 2
 addb 8,s
 adca #0
 std ,s
* r = (t & 0x0800) == 0x0800;
 anda #8
 sta 2,s
* t = (((t << 4) - t) << 2) + diff.t_second;
 lda ,s
 asld 4
 subd ,s
 asld 2
 addb 9,s
 adca #0
 std ,s
* /* fold it in */
* rand ^= t ^ ((uint) diff.t_seconds << 11) ^ ((uint) diff.t_seconds << 5);
 lda 9,s
 asla
 asla
 asla
 pshs a
 lda 10,s
 clrb
 asrd 3
 eora ,s+
 eora ,s
 eorb 1,s
 eora rand,y
 eorb rand+1,y
 std rand,y
* /* approximate days and add it in */
* t = (((diff.t_year << 1) + diff.t_year) << 2) + diff.t_month;
 clra
 ldb 4,s
 asld 1
 addb 4,s
 adca #0
 asld 2
 addb 5,s
 adca #0
 std 0,s
* rand += ((t << 5) - t - (t >> 1)) + diff.t_day + r;
 asld 5
 subd ,s
 asr ,s
 ror 1,s
 subd ,s
 addb 6,s
 adca #0
 tst 2,s
 beq trizp0
 addd #1
trizp0
 addd rand,y
 std rand,y
#endasm
}


/* produce an arbitrary number, and re-seed
*/
uint trand(limit)
uint limit;
{
  uint val;
  uint bit;

  val = rand % limit;
#asm
* bit = (limit | rand) & 0xf;
 clr 0,s
 ldb rand+1,y
 orb 9,s
 andb #$f
 stb 1,s
* rand += (limit >> 8) | (limit << 8);
 ldb 8,s
 lda 9,s
 addd rand,y
 std rand,y
#endasm
  rand = (rand << bit) | (rand >> (16 - bit));
  return(val);
}

