/* SCC$reversi.c#mwc0.01/26Apr1991 */
/* reversi: a game like Othello
*  An OS-9 version in C, by Joel Matthew Rees, Dec '89
*  Drastically modified for MS-DOS/TURBO-C March 1991 -- jmr
*  new OS-9/CoCo version Apr/May 1991
*  This version uses assembler in the radar routine, 
*  to see if there is any speed improvement.
*  Copyright 1991 Joel Matthew Rees
*  eliminated BORDER, pWIDTH for speed -- JMR 13Apr1991
*  Copyright for this program and all object code generated from it 
*  and its excerpts are assigned by the author to the public domain.
*  If your jurisdiction does not allow public domain assignment, 
*  you may use the following terms (MIT template):
** [Author(s)]
** Joel Rees, from November 2007 (JMR)
** All copyrights claimed and retained by the author(s).
** [License]
** This source may be used under the following conditions:
** * This source must be provided in some reasonable manner 
**   with any object distribution or publication.
** * This license notice may not be removed or modified.
** * Any modifications made to this file and published
**   shall receive the same license.
** * The author(s) make no legal representations whatsoever
**   concerning this source and the abstractions and/or
**   implementations contained therein:
** * Each user assumes all liability and responsibility
**   concerning such use.
** * USE AT YOUR OWN RISK.
** * The author(s) assert and concur that algorithms and 
**   other abstractions are fundamentally not patentable.
** * No other conditions are asserted.
** End of copyright and license notice.
*/

/* 
   problems with (LN *) casting in Microware C for OS-9/6809!
*/


#include <stdio.h>
#include <process.h>
#include <ctype.h>
#include <common.h>
#include <keybd.h>
#include "rand.h"
#include "board.h"


static char gbuf[4];

/* this probably ought have been defined in board.c!
*  getc for a path rather than a file pointer
*/
int getch(path)
int path;
{
  read(path, gbuf, 1);
  return(gbuf[0]);
}


#define KBRDY 1

/* this might also ought have been defined in board.c!
*  check for input available
*/
int kbhit(p)
int p;
{
  return (getstat(KBRDY, path) != EOF);
}


/* eat NUL prebytes and force upper case
*  caveats: punctuation (0x20 -- 0x3f) gets forced to control characters
*/
int getarrow()
{ int temp;

  while ((temp = getch(path)) == NUL) ;
  return (temp & ~0x20);
}


/* strategic values of board positions */
BD vals =
{
  {   8,  -4,   4,   2,   2,   4,  -4,   8 },
  {  -4,  -7,  -2,  -1,  -1,  -2,  -7,  -4 },
  {   4,  -2,   1,   0,   0,   1,  -2,   4 },
  {   2,  -1,   0,   0,   0,   0,  -1,   2 },
  {   2,  -1,   0,   0,   0,   0,  -1,   2 },
  {   4,  -2,   1,   0,   0,   1,  -2,   4 },
  {  -4,  -7,  -2,  -1,  -1,  -2,  -7,  -4 },
  {   8,  -4,   4,   2,   2,   4,  -4,   8 }
};

SQUARE *valp = (SQUARE *) vals;


#define DEPTH 7 /* must be one less than a power of two */
BD board[DEPTH + 1];
static int top = 0; /* top of the various stacks */
static int level; /* level of look-ahead */


/* for a fast offset and a cast that doesn't work in MWC
 should be LN *boardof(x)
*/
SQUARE *boardof(x)
int x; /* LSByte only */
{
#asm
 lda 5,s
 clrb
 asra
 rorb
 asra
 rorb
 leax board,y
 leax d,x
 tfr x,d
#endasm
}


/* translate an arrow key to cursor motion
*  Permute graphics mapping in this function
*  Perform bounding ELSEWHERE!!!
*/
SQUARE *cursmove(cursor, key)
SQUARE *cursor; uint key;
{ int k_d;

  switch (key) {
  case LEFT:
    k_d = -1; break;
  case RIGHT:
    k_d = 1; break;
  case DOWN:
    k_d = WIDTH; break;
  case UP:
    k_d = -WIDTH; break;
  case 'C':
    cursor = NULL; /* fall through */
  default:
    k_d = 0;
  }
  if (k_d != 0) {
    cursor += k_d;
  }
  return (cursor);
}


/* convert pointers to indices
*  8 byte wide board is faster than to / and %
* #asm code assumes sizeof(board) < 128
*/
xy(bd, pos, ax, ay)
LN *bd; SQUARE *pos; int *ax; int *ay;
{
#asm
* int dif = (pos - (SQUARE *) bd);
 ldd 6,s
 subd 4,s
 pshs b (0 <= d < 128)

* *ay = (dif >> 3);
 asrb
 asrb
 asrb
 std [11,s]
* *ax = (dif & 7);
 puls b
 andb #7
 std [8,s]
#endasm
}


/* erase board and fill in borders
*/
init(tboard)
LN *tboard;
{
  register SQUARE *bd = (SQUARE *) tboard;
  SQUARE *lim = ((SQUARE *) tboard) + WIDTH * WIDTH;

  while (bd < lim)
    *bd++ = NONE;
}


#define RANK7 (WIDTH * (WIDTH - 1))


/* check all directions for a scoring line
*  quits as soon as a scoring line is found
*  returns !FALSE if scoring line found
*  This might be done in a loop, but it should be faster unrolled
*/
int radar(bd, player, pos)
LN *bd; SQUARE player; SQUARE *pos;
{
#asm
* register SQUARE *base = (SQUARE *) bd;
 ldx 4,s
* int ipos = pos - base; ( 1,s )
* int beam = ipos; ( b )
 ldd 8,s
 subd 4,s
 cmpd #64
 bhs radno
ipos set 9
 stb ipos,s reuse pos LSB
* SQUARE other = -player; ( ,s )
player set 7
 lda player,s
 nega
other set 6
 sta other,s use player MSB

* if ((*pos == NONE) && (((unsigned) beam) < WIDTH * WIDTH)) {
 lda b,x
 beq radck
radno
 clra
 clrb
 puls u,pc
radck
*   if (beam < WIDTH * (WIDTH - 2)) { /* up the array */
 cmpb #48
 bhs rad3
*     if (base[beam += WIDTH] == other)
 addb #8
 lda b,x
 cmpa other,s
 bne rad1
*       while (beam < RANK7)
rad0l
 cmpb #56 RANK7
 bhs rad1
*         if (base[beam += WIDTH] != other)
 addb #8
 lda b,x
 cmpa other,s
 beq rad0l
*           if (base[beam] == player)
 cmpa player,s
*             goto ping;
 lbeq ping
*           else
*             break;
rad1
*     beam = ipos;
 ldb ipos,s
*     if ((beam & WM) < 6) /* up & right */
 lda ipos,s
 anda #7 WM
 cmpa #6
 bhs rad2
*       if (base[beam += WIDTH + 1] == other)
 addb #9
 lda b,x
 cmpa other,s
 bne rad2
*         while (((beam & WM) < 7) && (beam < RANK7 - 1))
rad1l
 cmpb #55 (RANK7 - 1)
 bhs rad2
 tfr b,a
 anda #7
 cmpa #7
 bhs rad2
*           if (base[beam += WIDTH + 1] != other)
 addb #9
 lda b,x
 cmpa other,s
 beq rad1l
*             if (base[beam] == player)
 cmpa player,s
*               goto ping;
 lbeq ping
*             else
*               break;
rad2
*     beam = ipos;
 ldb ipos,s
*     if ((beam & WM) > 1) /* up & left */
 lda ipos,s
 anda #7 WM
 cmpa #1
 bls rad3
*       if (base[beam += WIDTH - 1] == other)
 addb #7
 lda b,x
 cmpa other,s
 bne rad3
*         while (((beam & WM) > 0) && (beam < RANK7 - 1))
rad2l
 cmpb #55 (RANK7 - 1)
 bhs rad3
 tfr b,a
 anda #7
 beq rad3
*           if (base[beam += WIDTH - 1] != other)
 addb #7
 lda b,x
 cmpa other,s
 beq rad2l
*             if (base[beam] == player)
 cmpa player,s
*               goto ping;
 lbeq ping
*             else
*               break;
*   }
rad3
*   beam = ipos;
 ldb ipos,s
*   if (beam >= WIDTH * 2) { /* down the array */
 cmpb #16
 blo rad6
*     if (base[beam -= WIDTH] == other)
 subb #8
 lda b,x
 cmpa other,s
 bne rad4
*       while (beam >= WIDTH)
rad3l
 cmpb #8 WIDTH
 blo rad4
*         if (base[beam -= WIDTH] != other)
 subb #8
 lda b,x
 cmpa other,s
 beq rad3l
*           if (base[beam] == player)
 cmpa player,s
*             goto ping;
 lbeq ping
*           else
*             break;
rad4
*     beam = ipos;
 ldb ipos,s
*     if ((beam & WM) < 6) /* down & right */
 lda ipos,s
 anda #7
 cmpa #6
 bhs rad5
*       if (base[beam -= WIDTH - 1] == other)
 subb #7
 lda b,x
 cmpa other,s
 bne rad5
*         while (((beam & WM) < 7) && (beam > WIDTH))
rad4l
 cmpb #8 WIDTH
 bls rad5
 tfr b,a
 anda #7
 cmpa #7
 bhs rad5
*           if (base[beam -= WIDTH - 1] != other)
 subb #7
 lda b,x
 cmpa other,s
 beq rad4l
*             if (base[beam] == player)
 cmpa player,s
*               goto ping;
 lbeq ping
*             else
*               break;
rad5
*     beam = ipos;
 ldb ipos,s
*     if ((beam & WM) > 1) /* down & left */
 lda ipos,s
 anda #7
 cmpa #1
 bls rad6
*       if (base[beam -= WIDTH + 1] == other)
 subb #9
 lda b,x
 cmpa other,s
 bne rad6
*         while (((beam & WM) > 0) && (beam > WIDTH))
rad5l
 cmpb #8 WIDTH
 bls rad6
 tfr b,a
 anda #7
 beq rad6
*           if (base[beam -= WIDTH + 1] != other)
 subb #9
 lda b,x
 cmpa other,s
 beq rad5l
*             if (base[beam] == player)
 cmpa player,s
*               goto ping;
 beq ping
*             else
*               break;
*   }
rad6
*   beam = ipos;
 ldb ipos,s
*   if ((beam & WM) < 6) /* right */
 lda ipos,s
 anda #7
 cmpa #6
 bhs rad7
*     if (base[++beam] == other)
 incb
 lda b,x
 cmpa other,s
 bne rad7
*       while ((beam & WM) < 7)
rad6l
 tfr b,a
 anda #7
 cmpa #7
 bhs rad7
*         if (base[++beam] != other)
 incb
 lda b,x
 cmpa other,s
 beq rad6l
*           if (base[beam] == player)
 cmpa player,s
*             goto ping;
 beq ping
*           else
*             break;
rad7
*   beam = ipos;
 ldb ipos,s
*   if ((beam & WM) > 1) /* left */
 lda ipos,s
 anda #7
 cmpa #1
 lbls radno
*     if (base[--beam] == other)
 decb
 lda b,x
 cmpa other,s
 lbne radno
*       while ((beam & WM) > 0)
rad7l
 tfr b,a
 anda #7
 lbeq radno
*         if (base[--beam] != other)
 decb
 lda b,x
 cmpa other,s
 beq rad7l
*           if (base[beam] == player)
 cmpa player,s
*             goto ping;
 beq ping
*           else
*             break;
* }
* return(FALSE);
 lbra radno
ping
* return(TRUE);
 ldd #1
#endasm
}


/* put a piece down and capture lines
*  returns count captured, does not count piece played
*/
int play(bd, pos, player)
LN *bd; SQUARE *pos; SQUARE player;
{
  register SQUARE *base = (SQUARE *) bd;
  int ipos = pos - base;
  int beam = ipos;
  int pcs = 0;
  SQUARE other = -player;

  if ((*pos == NONE) && (((unsigned) beam) < WIDTH * WIDTH)) {
    while (beam < RANK7) /* up the array */
      if (base[beam += WIDTH] != other)
        break;
    if (base[beam] == player)
      while (base[beam -= WIDTH] == other) {
        base[beam] = player;
        pcs++;
      }
    beam = ipos;
    while (beam >= WIDTH) /* down the array */
      if (base[beam -= WIDTH] != other)
        break;
    if (base[beam] == player)
      while (base[beam += WIDTH] == other) {
        base[beam] = player;
        pcs++;
      }
    beam = ipos;
    while ((beam & WM) < 7) /* right */
      if (base[++beam] != other)
        break;
    if (base[beam] == player)
      while (base[--beam] == other) {
        base[beam] = player;
        pcs++;
      }
    beam = ipos;
    while ((beam & WM) > 0) /* left */
      if (base[--beam] != other)
        break;
    if (base[beam] == player)
      while (base[++beam] == other) {
        base[beam] = player;
        pcs++;
      }
    beam = ipos; /* up & right */
    while (((beam & WM) < 7) && (beam < RANK7))
      if (base[beam += WIDTH + 1] != other)
        break;
    if (base[beam] == player)
      while (base[beam -= WIDTH + 1] == other) {
        base[beam] = player;
        pcs++;
      }
    beam = ipos; /* up & left */
    while (((beam & WM) > 0) && (beam < RANK7))
      if (base[beam += WIDTH - 1] != other)
        break;
    if (base[beam] == player)
      while (base[beam -= WIDTH - 1] == other) {
        base[beam] = player;
        pcs++;
      }
    beam = ipos; /* down & right */
    while (((beam & WM) < 7) && (beam >= WIDTH))
      if (base[beam -= WIDTH - 1] != other)
        break;
    if (base[beam] == player)
      while (base[beam += WIDTH - 1] == other) {
        base[beam] = player;
        pcs++;
      }
    beam = ipos; /* down & left */
    while (((beam & WM) > 0) && (beam >= WIDTH))
      if (base[beam -= WIDTH + 1] != other)
        break;
    if (base[beam] == player)
      while (base[beam += WIDTH + 1] == other) {
        base[beam] = player;
        pcs++;
      }
    if (pcs > 0) {
      *pos = player;
      if (top == level + 1)
        pcs += valp[pos - (SQUARE *) bd];
    }
  }
  return(pcs);
}


/* seek a playable position, from pos, in increasing order
*  restores pos to board boundaries before seeking
*  before or after board will start at bd[0][0]
*  tests (restored) pos first
*  return NULL if no position playable after returning to pos
*/
SQUARE *seek(bd, pos, turn)
LN *bd; SQUARE *pos; SQUARE turn;
{
  register SQUARE *hunt;
  SQUARE *bhome = (SQUARE *) bd;
  SQUARE *bend = (SQUARE *) bd + WIDTH * WIDTH - 1;

  if ((pos < bhome) || (pos > bend))
    pos = bhome;
  hunt = pos;
  do {
    if (*hunt == NONE)
      if (radar(bd, turn, hunt)) {
        pos = NULL; /* force hunt != pos */
        break;
      }
    if (++hunt > bend)
      hunt = bhome;
  } while (hunt != pos);
  return (hunt == pos ? NULL : hunt);
}


/* wrap pos around center
*/
SQUARE *wrapsq(bd, pos, lo, hi)
LN *bd; SQUARE *pos; int lo; int hi;
{ int i, j;

  xy(bd, pos, &j, &i);
  if (i < lo)
    i = hi;
  else if (i > hi)
    i = lo;
  if (j < lo)
    j = hi;
  else if (j > hi)
    j = lo;
  return ((SQUARE *) bd + (i << 3) + j);
}


/* drop out unceremoniously
*  (have to provide some orderly emergency exit!)
*/
quit(turn)
SQUARE turn;
{
  int resp;

  Bell(path);
  prompt(REALLY, turn);
  resp = tolower(getch(path));
  if ((resp == 'y') || (resp == 'q')) {
    endgraph();
    printf("So glad you could join us!\n");
    exit(0);
  }
  unprompt(REALLY);
}


/* copy top level to test level,
*  initializes and cancels operations on test level,
*/
revert()
{
#asm
* register SQUARE *scan = (SQUARE *) board + (top << 6);
 ldd top,y
 pshs d
 lbsr boardof
 tfr d,x
* SQUARE *last = scan + WIDTH * WIDTH;
 leau 64,x
 stu ,s

* while (scan < last) {
 bra revt
revlup
*   scan[0] = scan[-(WIDTH * WIDTH)];
 ldd -64,x two at a time
 std ,x++
*   scan++;
* }
revt
 cmpx ,s
 blo revlup
 leas 2,s
#endasm
}


/* find best play, recursive to level
*  return a value for the play
*  uses *pos to seed seek()
*  also uses *pos to flag noplay for next level of recursion
*  displays the cursor when evaluating level 0
*  also checks for keyboard quit when evaluating level 0
*/
int eval(turn, pos)
SQUARE turn; SQUARE **pos;
{
  SQUARE *test; /* should be (LN *) */
  register SQUARE *check = (*pos) + WIDTH * WIDTH;
  SQUARE *oldc = NULL;
  SQUARE *best = NULL;
  int val;
  int oldv = MININT;
  int x, y;
  SQUARE *other = NULL;

  test = boardof(++top);
  revert();
  check = seek(test, check - WIDTH - 1, turn); /* seek neighboring */
  oldc = check; /* flag end */
  other = check; /* flag noplay for deeper levels */
  do {
    if (check != NULL) {
      if (top == 1) {
        if (kbhit(path))
          if ((getch(path) | 0x20) == 'q')
            quit(turn);
        xy(test, check, &x, &y);
        showcursor(x, y, TRUE);
      }
      val = play(test, check, turn);
    }
    else {
      val = 0;
      if ((check == NULL) && (*pos == NULL))
        break; /* no play left */
    }
    if (top < level)
      val -= eval(-turn, &other);
    if (val > oldv) {
      oldv = val;
      best = check;
    }
    else if ((val == oldv) && (trand(1001 + top) & 32))
      best = check;
    revert();
    check++;
    if (top == 1) {
      if (kbhit(path))
        if ((getch(path) | 0x20) == 'q')
          quit(turn);
      clrcursor();
    }
  } while ((check = seek(test, check, turn)) != oldc);
  --top;
  *pos = (best == NULL) ? NULL : boardof(top) + (best - (SQUARE *) test);
  return(oldv);
}


/* get a play from a user
*  return NULL if computer selected or no play
*/
SQUARE *getuplay(turn, pos)
SQUARE turn; SQUARE *pos;
{
  SQUARE *cursor = seek(board, pos - WIDTH - 1, turn); /* neighbor */
  uint key;
  int x, y;

  if (cursor != NULL) {
    Bell(path);
    prompt(WILLPLAY, turn);
    key = 1; /* not NUL, no action */
    do {
      xy(board, cursor, &x, &y);
      showcursor(x, y, (key != NUL));
      cursor = cursmove(cursor, key = getarrow());
      if (key == 'Q')
        quit(turn);
      clrcursor();
      if (cursor != NULL)
        cursor = wrapsq(board, cursor, 0, 7);
      else
        break;
      if (radar(board, turn, cursor)) {
        Bell(path);
        prompt(WILLPLAY, turn);
      }
      else {
        key = NUL;
        prompt(NOGOOD, turn);
      }
    } while(key != '\r');
  }
  unprompt(WILLPLAY);
  return(cursor);
}


static int turnf[BLACK - WHITE + 1]; /* set by getprefs */
static int *uturn = turnf + 1; /* for accessing turn by player */

/* get a position to play a turn
*  returns the position to play
*/
SQUARE *getplay(turn)
SQUARE turn;
{
  static SQUARE *mem = (SQUARE *) board;
  SQUARE *mtemp;

  if (uturn[turn]) {
    prompt(USER, turn);
    mtemp = getuplay(turn, mem);
    unprompt(USER);
  }
  if (!uturn[turn] || (mtemp == NULL)) {
    prompt(COMPUTER, turn);
    eval(turn, &mem);
    unprompt(COMPUTER);
  }
  else
    mem = mtemp;
  return(mem);
}


/* find an empty position in the center four
*  forces pos to "nearest" center position if out of bounds
*  returns pos found or NULL
*/
SQUARE *seekctr(pos)
register SQUARE *pos;
{ SQUARE *pos33 = (SQUARE *) board + 3 * WIDTH + 3;
  SQUARE *pos43 = pos33 + WIDTH;
  SQUARE *old = NULL;

  if (pos < pos33)
    pos = pos33;
  while (TRUE) {
    if ((pos > pos33 + 1) && (pos < pos43))
      pos = pos43;
    else if (pos > pos43 + 1)
      pos = pos33;
    if ((*pos == NONE) || (pos == old))
      break;
    if (old == NULL)
      old = pos;
    pos++;
  }
  return (*pos == NONE ? pos : NULL);
}


/* let user select one of first four moves
*  returns position selected
*  if no position available, returns NULL
*/
SQUARE *getuctr(turn)
SQUARE turn;
{
  SQUARE *cursor = seekctr((SQUARE *) board);
  uint key;
  int x, y;

  if (cursor != NULL) {
    Bell(path);
    prompt(WILLPLAY, turn);
    key = 1; /* not NUL, no action */
    do {
      xy(board, cursor, &x, &y);
      showcursor(x, y, (key != NUL));
      cursor = cursmove(cursor, key = getarrow());
      if (key == 'Q')
        quit(turn);
      clrcursor();
      if (cursor != NULL)
        cursor = wrapsq(board, cursor, 3, 4);
      else
        break;
      if (*cursor != NONE) {
        prompt(NOGOOD, turn);
        key = NUL;
      }
      else
        prompt(WILLPLAY, turn);
    } while(key != '\r');
  }
  unprompt(WILLPLAY);
  return(cursor);
}


/* have computer find one of the first four moves
*  return position found or NULL
*/
SQUARE *getcctr()
{ SQUARE *pos = (SQUARE *) board + WIDTH * 3 + 3;

  if (trand(129) & 8)
    pos++;
  if (trand(511) & 4)
    pos += WIDTH;
  return (seekctr(pos));
}


/* set by getprefs
*  flag diagonal first four plays
*/
static int diag;


firstplay()
{ SQUARE turn = BLACK;
  SQUARE *pos = NULL;
  SQUARE *pos43 = (SQUARE *) board + 4 * WIDTH + 3;
  int off;

  while (TRUE) {
    display((SQUARE *) board, turn);
    prompt(uturn[turn], turn);
    if (uturn[turn])
      pos = getuctr(turn);
    if (!uturn[turn] || (pos == NULL))
      pos = getcctr();
    unprompt(uturn[turn]);
    if (pos == NULL)
      break;
    *pos = turn;
    if (diag) {
      off = pos43 - pos + 1;
      *((off & 1) ? pos + 1 : pos - 1) = -turn;
      pos += (pos >= pos43) ? -WIDTH : WIDTH;
      *pos = -turn;
      *((off & 1) ? pos + 1 : pos - 1) = turn;
      break;
    }
    turn = -turn;
  }
}


/* read a char and flush to EOL
*/
int getc2cr()
{ int ch = getchar();

  while (getchar() != '\n') ;
  return (ch);
}


getprefs()
{ trandize();
  printf("A game of Reversi\n\n");
  printf("Copyright 1991, Joel Matthew Rees\n");
  printf("   565 E. Mansfield Ave,\n   South Salt Lake City, Utah 84106\n\n");
  printf("Enter skill level <0 .. %d>\n", DEPTH);
  level = (DEPTH & getc2cr());
  printf("\nWill the computer play black? <y/n>\n");
  uturn[BLACK] = !(tolower(getc2cr()) == 'y');
  printf("\nWill the computer play white? <y/n>\n");
  uturn[WHITE] = !(tolower(getc2cr()) == 'y');
  printf("\nWill the first four plays be\n   diagonal <y/n>\n");
  diag = tolower(getc2cr()) == 'y';
  printf("\nInstructions:\n");
  printf("Use cursor keys\n   and press <ENTER> to select play.\n");
  printf("Press <C>\n   to have the computer play for you.\n");
  printf("Press any key to start the game.\n");
  getchar();
  trandize();
}


main()
{
  int noplay = FALSE;
  SQUARE turn = BLACK;
  SQUARE *pos;

  getprefs();
  gograph();
  init(board);
  putboard();
  firstplay();
  do {
    display(board, turn);
    prompt(CONTINUE, turn);
    getch(path);
    if ((pos = getplay(turn)) == NULL) {
      noplay++;
      prompt(NOPLAY, turn);
    }
    else {
      noplay = FALSE;
      play(board, pos, turn);
    }
    turn = -turn;
  } while (noplay < 2);
  display(board, 0);
  prompt(QUIT, turn);
  getch(path);
  endgraph();
  printf("Thank you.\n  Come again.\n");
  return(0);
}

