/* Common include stuff for an eight-bit framework 
// for testing various arithmetic techniques.
// Written by Joel Matthew Rees
// Copyright 2013, Joel Matthew Rees
// Distribution and use permitted under terms of the GPL v. 3,
// See the included file, LICENSE.TXT,
// or on-line at <http://www.gnu.org/licenses/>. 
*/


#include <stdlib.h>
#include <limits.h>


#if !defined NIBBIT_H
#define NIBBIT_H


typedef unsigned char uchar_t;

#define STACKDEPTH 64
extern uchar_t myStack[ STACKDEPTH ];
extern uchar_t * mySP;

/* This doesn't placate the warnings about myStack not being 
// -- explicitly!! --
// initialized.
*/
extern void initMyStack( void );


#define BYTEBITS (CHAR_BIT)
 
#define NIBCT ((uchar_t) ( BYTEBITS / 2 ))
#define NIBHIMASK ((uchar_t) ( UCHAR_MAX << NIBCT ) )
#define NIBHI( BYTE ) ((uchar_t) ( BYTE & NIBHIMASK ))
#define NIBHIDOWN( BYTE ) ((uchar_t) ( BYTE >> NIBCT ))
#define NIBLOMASK ((uchar_t) UCHAR_MAX >> NIBCT )
#define NIBLO( BYTE ) ((uchar_t) ( BYTE & NIBLOMASK ))
#define NIBLOUP( BYTE ) ((uchar_t) ( BYTE << NIBCT ))
#define NIBCARRYMASK( BYTE ) ((uchar_t) ( 1 << NIBCT ))
#define NIBCARRYBIT( BYTE ) ( 1 & ( BYTE >> NIBCT ) )

#define BYTEHIBIT SCHAR_MIN
#define BYTELOBIT 1
#define BYTEMASK 0xff


extern void nibDAdd( void );


extern void nibDSub( void );


extern void nibUMul( void );


extern void nibUDiv( void );
/* Sould be commented out except to show the high word in testing. */
#define TESTUDIVHIGHWORD

extern void nibBUDiv( void );


#endif /* !defined NIBBIT_H */


