import java.io.*;
import java.util.*;

import static java.lang.Math.*;
import static java.lang.Integer.*;


public class RectanglesAndHoles {

	final double EPS = 0.00000000001;
	static PrintStream err = null;
	static long progtime = 0;
	
	static int N = 0;
	Random rnd = new Random();
	static boolean debug = true;

	static void debug(String s){
		if(debug){
			err.print(s);
		}
	}
	static void debug(int i){
		if(debug){
			err.print(i);
		}
	}
	
	public int[] place(int[] A, int[] B){
		long start =  System.currentTimeMillis();

		int[] ret = null;
		N = A.length;
		List<R> orgs = new ArrayList<R>();
		List<R> ls = new ArrayList<R>();
		List<R> remains = new ArrayList<R>();
		List<G> groups = new ArrayList<G>();

		try{
			for(int i = 0; i < N; i++){
				R r = new R();
				r.a = A[i];
				r.b = B[i];
				r.idx = i;
				ls.add(r);
				orgs.add(r);
			}
			
			while(ls.size() >= 4){
				int y = 0;
				int x = 0;
				int firstx = 0;
				int wide = 0;
				G g = new G();
				{
					R r = ls.remove(0);
					if(r.a >= r.b){
						y = r.a;
						x = r.b;
						firstx = x;
						r.d = 1;
					}
					else{
						y = r.b;
						x = r.a;
						firstx = x;
						r.d = 0;
					}
					g.rs.add(r);
				}
				{
					R r = ls.remove(0);
					r.y = y;
					r.x = x;
					if(r.a >= r.b){
						x += r.a;
						r.d = 0;
						wide = r.a;
					}
					else{
						x += r.b;
						r.d = 1;
						wide = r.b;
					}
					g.rs.add(r);
				}
				{
					R r = ls.remove(0);
					if(r.a >= r.b){
						y -= r.a;
						r.d = 1;
					}
					else{
						y -= r.b;
						r.d = 0;
					}
					r.y = y;
					r.x = x;
					g.rs.add(r);
				}
				
				R last = null;
				for(R r : ls){
					if(r.a >= wide || r.b >= wide){
						last = r;
						ls.remove(r);
						break;
					}
				}
				if(last != null){
					int lg = 0;
					int st = 0;
					if(last.a >= last.b){
						lg = last.a;
						st = last.b;
						last.d = 0;
					}
					else{
						lg = last.b;
						st = last.a;
						last.d = 1;
					}
					
					if(y < 0){
						last.x = x - lg;
						last.y = - st;
					}
					else{
						last.y = y - st;
						last.x = firstx;;
					}
					g.rs.add(last);
					groups.add(g);
				}
				else{
					remains.addAll(g.rs);
				}
				
			}
			remains.addAll(ls);
			
			
			List<L> lines = new ArrayList<L>();
			
			for(int i = 0; i < groups.size(); i++){
				G g = groups.get(i);
				List<L> cls = null;
				while(true){
					g.oy = nextrnd();
					g.ox = nextrnd();
					cls  = new ArrayList<L>();
					for(R r : g.rs){
						cls.addAll(getLines(r, g.oy, g.ox));
					}
					
					if(!iscross(lines, cls)){
						break;
					}
				}
				lines.addAll(cls);
			}
			
			for(R r : remains){
				List<L> mls = null;
				int oy = 0;
				int ox = 0;
				while(true){
					oy = nextrnd();
					ox = nextrnd();
					mls = getLines(r, oy, ox);
					if(!iscross(lines, mls)){
						break;
					}
				}
				lines.addAll(mls);
				r.y += oy;
				r.x += ox;
			}
			
			for(G g : groups){
				int oy = g.oy;
				int ox = g.ox;

				
				for(R r : g.rs){
					r.y += oy;
					r.x += ox;
				}
			}

			ret = new int[N*3];
			for(int i = 0; i < N; i++){
				R r = orgs.get(i);
				ret[3*i] = r.x;
				ret[3*i+1] = r.y;
				ret[3*i+2] = r.d;
			}
			
		}
		catch(Exception ex){
			err.println(ex.getMessage());
		}
		
		progtime += System.currentTimeMillis() - start;
		return ret;
	}
	
	private boolean iscross(List<L> l1, List<L> l2){
		for(L ml : l1){
			for(L l : l2){
				if(cross(ml, l)){
					return true;
				}
			}
		}
		return false;
	}
	
	private int nextrnd(){
		return rnd.nextInt(1800000) - 900000;
	}
	
	List<L> getLines(R r, int oy, int ox){
		List<L> l = new ArrayList<L>();
		int y = r.y + oy;
		int x = r.x + ox;
		if(r.d == 0){
			int ny = y + r.b;
			int nx = x;
			l.add(new L(y, x, ny, nx));
			y = ny;
			x = nx;
			nx += r.a;
			l.add(new L(y, x, ny, nx));
			y = ny;
			x = nx;
			ny -= r.b;
			l.add(new L(y, x, ny, nx));
			y = ny;
			x = nx;
			nx -= r.a;
			l.add(new L(y, x, ny, nx));
		}
		else{
			int ny = y + r.a;
			int nx = x;
			l.add(new L(y, x, ny, nx));
			y = ny;
			x = nx;
			nx += r.b;
			l.add(new L(y, x, ny, nx));
			y = ny;
			x = nx;
			ny -= r.a;
			l.add(new L(y, x, ny, nx));
			y = ny;
			x = nx;
			nx -= r.b;
			l.add(new L(y, x, ny, nx));
		}
		
		return l;
	}

	
	boolean cross(L l1, L l2){
		int ly1 = Math.max(l1.y1, l1.y2);
		int sy1 = Math.min(l1.y1, l1.y2);
		int ly2 = Math.max(l2.y1, l2.y2);
		int sy2 = Math.min(l2.y1, l2.y2);
		
		int lx1 = Math.max(l1.x1, l1.x2);
		int sx1 = Math.min(l1.x1, l1.x2);
		int lx2 = Math.max(l2.x1, l2.x2);
		int sx2 = Math.min(l2.x1, l2.x2);
		
		
		if(l1.x1 == l1.x2){
			if(l2.x1 == l2.x2){
				if(l1.x1 == l2.x1){
					if(sy2 < sy1 && sy1 < ly2 || sy2 < ly1 && ly1 < ly2 ||
						sy1 < sy2 && sy2 < ly1 || sy1 < ly2 && ly2 < ly1){
						return true;
					}
				}
			}
			else{
				if(sy1 < l2.y1 && l2.y1 < ly1 && sx2 < l1.x1 && l1.x1 < lx2){
					return true;
				}
			}
		}
		else{
			if(l2.y1 == l2.y2){
				if(l1.y1 == l2.y1){
					if(sx2 < sx1 && sx1 < lx2 || sx2 < lx1 && lx1 < lx2 ||
						sx1 < sx2 && sx2 < lx1 || sx1 < lx2 && lx2 < lx1){
							return true;
					}
				}
			}
			else{
				if(sx1 < l2.x1 && l2.x1 < lx1 && sy2 < l1.y1 && l1.y1 < ly2){
					return true;
				}
			}
		}

		return false;
	}
	

	class L{
		public L(int y1, int x1, int y2, int x2){
			this.y1 = y1;
			this.x1 = x1;
			this.y2 = y2;
			this.x2 = x2;
		}
		int y1 = 0;
		int x1 = 0;
		int y2 = 0;
		int x2 = 0;
	}
	
			
	
	class R{
		int a = 0;
		int b = 0;
		int idx = 0;
		int y = 0;
		int x = 0;
		int d = 0;
	}
	
	class G {
		List<R> rs = new ArrayList<R>();
		int oy = 0;
		int ox = 0;
	}

	
	
	
	
	public static void main(String[] args) throws Exception{
		RectanglesAndHoles r = new RectanglesAndHoles();
		//s.test();
		err = System.err;

		progtime = 0;

		BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
		BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(System.out));

		String s = null;
		while( (s = br.readLine()) != null){
			int n = parseInt(s);
			int[] A = new int[n];
			int[] B = new int[n];
			for(int i = 0; i < n; i++){
				A[i] = parseInt(br.readLine());
			}
			for(int i = 0; i < n; i++){
				B[i] = parseInt(br.readLine());
			}
			int[] ret = r.place(A, B);
			debug("407 : " + ret[407]);
			for(int i = 0; i < ret.length; i++){
				bw.write(ret[i] + "\n");
			}
			bw.flush();
		}

	    bw.close();
	    br.close();
	    err.println("time : " + progtime);
	}

}
