package com.example.hello.android.google_play_service_account_picker;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import com.google.android.gms.common.AccountPicker;

public class MainActivity extends Activity
	implements View.OnClickListener
{

	private static final String LOG_TAG = "XXX";
	private static int REQUEST_CODE_PICK_ACCOUNT = 101;
	private String accountName;
	private String accountType;

	@Override
	public void onClick(View view)
	{
		Log.v(LOG_TAG, "onClick() : Hello");
		switch (view.getId())
		{
			case R.id.pick_account_button:
				startAccountPicker();

				break;
			default:
				throw new AssertionError();
		}

		Log.v(LOG_TAG, "onClick() : Bye");
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu)
	{
		MenuInflater menuInflater = getMenuInflater();
		menuInflater.inflate(R.menu.quit_menuitem, menu);

		return true;
	}

	@Override
	public boolean onPrepareOptionsMenu(Menu menu)
	{
		Log.v(LOG_TAG, "onPrepareOptionsMenu() : Hello");

		Log.v(LOG_TAG, "onPrepareOptionsMenu() : Bye");
		return super.onPrepareOptionsMenu(menu);
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item)
	{
		boolean result = true;
		Log.v(LOG_TAG, "onOptionsItemSelected() : Hello");

		switch (item.getItemId())
		{
			case R.id.quit_menuitem:
				finish();
				break;
			default:
				result = super.onOptionsItemSelected(item);
		}

		Log.v(LOG_TAG, "onOptionsItemSelected() : Bye");
		return result;
	}

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		Log.v(LOG_TAG, "onCreate() : Hello");
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main_activity);

		Button pickAccountButton = (Button) findViewById(R.id.pick_account_button);
		pickAccountButton.setOnClickListener(this);

		Log.v(LOG_TAG, "onCreate() : Bye");
	}

	@Override
	protected void onStart()
	{
		Log.v(LOG_TAG, "onStart() : Hello");
		super.onStart();
		Log.v(LOG_TAG, "onStart() : Bye");
	}

	@Override
	protected void onStop()
	{
		Log.v(LOG_TAG, "onStop() : Hello");
		super.onStop();
		Log.v(LOG_TAG, "onStop() : Bye");
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data)
	{
		Log.v(LOG_TAG, "onActivityResult() : Hello");
		if (requestCode == REQUEST_CODE_PICK_ACCOUNT && resultCode == RESULT_OK)
		{
			accountType = data.getStringExtra(AccountManager.KEY_ACCOUNT_TYPE);
			accountName = data.getStringExtra(AccountManager.KEY_ACCOUNT_NAME);
			Log.v(LOG_TAG, "onActivityResult() : accountType => " + accountType);
			Log.v(LOG_TAG, "onActivityResult() : accountName => " + accountName);

			updateAccountTextViews();
		}
		Log.v(LOG_TAG, "onActivityResult() : Bye");
	}

	private void updateAccountTextViews()
	{
		TextView accountTypeTextView = (TextView) findViewById(R.id.account_type_textview);
		accountTypeTextView.setText(accountType);
		TextView accountNameTextView = (TextView) findViewById(R.id.account_name_textview);
		accountNameTextView.setText(accountName);
	}

	private void startAccountPicker()
	{
		Account selectedAccount = null;
		if (accountName != null)
		{
			selectedAccount = new Account(accountName, accountType);
		}

		Intent intent = AccountPicker.newChooseAccountIntent(selectedAccount, null, new String[]
		{
			"com.google"
		}, true, null, null, null, null);
		startActivityForResult(intent, REQUEST_CODE_PICK_ACCOUNT);
	}
}
