/*
 *  The MIT License
 * 
 *  Copyright 2011-2012 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 * 
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 * 
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 * 
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */
package com.example.hello.android.appwidget_listview;

import android.app.PendingIntent;
import android.appwidget.AppWidgetManager;
import android.appwidget.AppWidgetProvider;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.util.Log;
import android.widget.RemoteViews;

/**
 *
 * @author sawai
 */
public class ListViewAppWidgetProvider extends AppWidgetProvider
{

	private static final String LOG_TAG = "HelloAppWidgetProvider";

	@Override
	public void onUpdate(Context context, AppWidgetManager appWidgetManager, int[] appWidgetIds)
	{
		Log.v(LOG_TAG, "onUpdate() : Hello");

		RemoteViews remoteViews = new RemoteViews(context.getPackageName(),
			R.layout.listview_appwidget);

		// ListView にデータをバインドするサービスを示すインテントを作る
		Intent intent = new Intent(context, ListViewAppWidgetRemoteViewsService.class);
		intent.putExtra(AppWidgetManager.EXTRA_APPWIDGET_IDS, appWidgetIds);
		Uri intentUri = Uri.parse(intent.toUri(Intent.URI_INTENT_SCHEME));
		Log.d(LOG_TAG, "onUpdate() : intentUri => " + intentUri);
		intent.setData(intentUri);
		Log.d(LOG_TAG, "onUpdate() : intent => " + intent);

		// ListView と ListViewAppWidgetRemoteViewsService を結びつける
		remoteViews.setRemoteAdapter(appWidgetIds[0], R.id.names_listview, intent);

		// names_listview にデータがなかった時表示するビューを empty_textview に設定
		remoteViews.setEmptyView(R.id.names_listview, R.id.empty_textview);

		// ListView の要素がクリックした際に発行するインテントのテンプレートを設定
		Intent templateIntent = new Intent(context, HelloActivity.class);
		PendingIntent template = PendingIntent.getActivity(context, 0,
			templateIntent, PendingIntent.FLAG_UPDATE_CURRENT);
		remoteViews.setPendingIntentTemplate(R.id.names_listview, template);

		// Update AppWidgets
		appWidgetManager.updateAppWidget(appWidgetIds, remoteViews);

		Log.v(LOG_TAG, "onUpdate() : Bye");
	}
}
