/*
 * The MIT License
 *
 * Copyright 2012 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.actionbar_nav_mode_tab_fragment;

import android.app.ActionBar;
import android.app.ActionBar.Tab;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentTransaction;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;

public class MainActivity extends Activity
	implements ActionBar.TabListener
{

	private static final String LOG_TAG = "XXX";
	private static final String SELECTED_NAVIGATION_ITEM_KEY = "SELECTED_NAVIGATION_ITEM_KEY";
	private Tab addTab;
	private Tab editTab;
	private Tab shareTab;
	private Tab searchTab;
	private Fragment addFragment;
	private Fragment editFragment;
	private Fragment shareFragment;
	private Fragment searchFragment;

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		Log.v(LOG_TAG, "onCreate() : Hello");
		super.onCreate(savedInstanceState);

		// Setup actionbar 
		ActionBar actionBar = getActionBar();
		actionBar.setNavigationMode(ActionBar.NAVIGATION_MODE_TABS);

		// Disable Title
		actionBar.setDisplayShowTitleEnabled(false);

		addTab = actionBar.newTab();
		addTab.setText(R.string.add);
//		addTab.setContentDescription(R.string.add_description);
		addTab.setIcon(android.R.drawable.ic_menu_add);
		addTab.setTabListener(this);
		actionBar.addTab(addTab);

		editTab = actionBar.newTab();
		editTab.setText(R.string.edit);
//		editTab.setContentDescription(R.string.edit_description);
		editTab.setIcon(android.R.drawable.ic_menu_edit);
		editTab.setTabListener(this);
		actionBar.addTab(editTab);

		shareTab = actionBar.newTab();
		shareTab.setText(R.string.share);
//		shareTab.setContentDescription(R.string.share_description);
		shareTab.setIcon(android.R.drawable.ic_menu_share);
		shareTab.setTabListener(this);
		actionBar.addTab(shareTab);

		searchTab = actionBar.newTab();
		searchTab.setText(R.string.search);
//		searchTab.setContentDescription(R.string.search_description);
		searchTab.setIcon(android.R.drawable.ic_menu_search);
		searchTab.setTabListener(this);
		actionBar.addTab(searchTab);

		if (savedInstanceState != null)
		{
			int item = savedInstanceState.getInt(SELECTED_NAVIGATION_ITEM_KEY);
			actionBar.setSelectedNavigationItem(item);
		}

		Log.v(LOG_TAG, "onCreate() : Bye");
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu)
	{
		MenuInflater menuInflater = getMenuInflater();
		menuInflater.inflate(R.menu.quit_menu, menu);

		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item)
	{
		boolean result = true;

		int itemId = item.getItemId();
		switch (itemId)
		{
			case R.id.quit_menuitem:
				finish();
				break;
			default:
				result = super.onOptionsItemSelected(item);

		}

		return result;
	}

	@Override
	protected void onSaveInstanceState(Bundle outState)
	{
		ActionBar actionBar = getActionBar();
		int item = actionBar.getSelectedNavigationIndex();
		outState.putInt(SELECTED_NAVIGATION_ITEM_KEY, item);

		super.onSaveInstanceState(outState);
	}

	public void onTabSelected(Tab tab, FragmentTransaction ft)
	{
		Log.v(LOG_TAG, "onTabSelected() : Hello");

		Log.d(LOG_TAG, "onTabUnselected() : tab => " + tab.getText());
		attachFragmentForTab(ft, tab);

		Log.v(LOG_TAG, "onTabSelected() : Bye");
	}

	public void onTabUnselected(Tab tab, FragmentTransaction ft)
	{
		Log.v(LOG_TAG, "onTabUnselected() : Hello");

		Log.d(LOG_TAG, "onTabUnselected() : tab => " + tab.getText());
//		detachFragmentForTab(ft, tab);

		Log.v(LOG_TAG, "onTabUnselected() : Bye");
	}

	public void onTabReselected(Tab tab, FragmentTransaction ft)
	{
		Log.v(LOG_TAG, "onTabReselected() : Hello");
		Log.v(LOG_TAG, "onTabReselected() : Bye");
	}

	private void attachFragmentForTab(FragmentTransaction ft, Tab tab)
	{
		Log.v(LOG_TAG, "attachFragmentForTab() : Hello");
		if (tab == addTab)
		{
			if (addFragment == null)
			{
				addFragment = new AddFragment();
			}
			ft.replace(android.R.id.content, addFragment, "add");
		}
		else if (tab == editTab)
		{
			if (editFragment == null)
			{
				editFragment = new EditFragment();
			}
			ft.replace(android.R.id.content, editFragment, "add");
		}
		else if (tab == shareTab)
		{
			if (shareFragment == null)
			{
				shareFragment = new ShareFragment();
			}
			ft.replace(android.R.id.content, shareFragment, "add");
		}
		else if (tab == searchTab)
		{
			if (searchFragment == null)
			{
				searchFragment = new SearchFragment();
			}
			ft.replace(android.R.id.content, searchFragment, "add");
		}

		Log.v(LOG_TAG, "attachFragmentForTab() : Bye");
	}
}
