/*
 * The MIT License
 *
 * Copyright 2013 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.actionbar_nav_mode_tab_hello;

import android.app.ActionBar;
import android.app.ActionBar.Tab;
import android.app.Activity;
import android.app.FragmentTransaction;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;

public class MainActivity extends Activity
	implements ActionBar.TabListener
{

	private static final String LOG_TAG = "XXX";
	private Tab addTab;
	private Tab editTab;
	private Tab shareTab;
	private Tab searchTab;

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main_activity);

		// Setup actionbar 
		ActionBar actionBar = getActionBar();
		actionBar.setNavigationMode(ActionBar.NAVIGATION_MODE_TABS);

		// Disable Title
		actionBar.setDisplayShowTitleEnabled(false);

		addTab = actionBar.newTab();
		addTab.setText(R.string.add);
//		addTab.setContentDescription(R.string.add_description);
		addTab.setIcon(android.R.drawable.ic_menu_add);
		addTab.setTabListener(this);
		actionBar.addTab(addTab);

		editTab = actionBar.newTab();
		editTab.setText(R.string.edit);
//		editTab.setContentDescription(R.string.edit_description);
		editTab.setIcon(android.R.drawable.ic_menu_edit);
		editTab.setTabListener(this);
		actionBar.addTab(editTab);

		shareTab = actionBar.newTab();
		shareTab.setText(R.string.share);
//		shareTab.setContentDescription(R.string.share_description);
		shareTab.setIcon(android.R.drawable.ic_menu_share);
		shareTab.setTabListener(this);
		actionBar.addTab(shareTab);

		searchTab = actionBar.newTab();
		searchTab.setText(R.string.search);
//		searchTab.setContentDescription(R.string.search_description);
		searchTab.setIcon(android.R.drawable.ic_menu_search);
		searchTab.setTabListener(this);
		actionBar.addTab(searchTab);

	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu)
	{
		MenuInflater menuInflater = getMenuInflater();
		menuInflater.inflate(R.menu.quit_menu, menu);

		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item)
	{
		boolean result = true;

		int itemId = item.getItemId();
		switch (itemId)
		{
			case R.id.quit_menuitem:
				finish();
				break;
			default:
				result = super.onOptionsItemSelected(item);

		}

		return result;
	}

	public void onTabSelected(Tab tab, FragmentTransaction ft)
	{
		Log.d(LOG_TAG, "onTabSelected() : Hello");
		setTabContentVisibility(tab, View.VISIBLE);
		Log.d(LOG_TAG, "onTabSelected() : Bye");
	}

	public void onTabUnselected(Tab tab, FragmentTransaction ft)
	{
		Log.d(LOG_TAG, "onTabUnselected() : Hello");
		setTabContentVisibility(tab, View.GONE);
		Log.d(LOG_TAG, "onTabUnselected() : Bye");
	}

	public void onTabReselected(Tab tab, FragmentTransaction ft)
	{
		Log.d(LOG_TAG, "onTabReselected() : Hello");
		Log.d(LOG_TAG, "onTabReselected() : Bye");
	}

	private void setTabContentVisibility(Tab tab, int visibility)
	{
		int contentId = -1;

		if (tab == addTab)
		{
			contentId = R.id.add_content;
		}
		else if (tab == editTab)
		{
			contentId = R.id.edit_content;
		}
		else if (tab == shareTab)
		{
			contentId = R.id.share_content;
		}
		else if (tab == searchTab)
		{
			contentId = R.id.search_content;
		}

		if (contentId != -1)
		{
			// hide unselected tab content
			View contentView = findViewById(contentId);
			if (contentView != null)
			{
				contentView.setVisibility(visibility);
			}
		}
	}
}
