package com.example.hello.android.bitmap_drawing_and_show;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Bundle;
import android.util.Log;
import android.widget.ImageView;
import java.util.Random;

public class MainActivity extends Activity
{

	private static final String LOG_TAG = "XXX";
	private static final int IMAGE_WIDTH = 320;
	private static final int IMAGE_HEIGHT = 320;

	@Override
	public void onCreate(Bundle savedInstanceState)
	{
		Log.v(LOG_TAG, "onCreate() : Hello");

		setTheme(android.R.style.Theme_NoTitleBar_Fullscreen);
		super.onCreate(savedInstanceState);

		ImageView imageView = new ImageView(this);
		imageView.setImageBitmap(createCirclesBitmap());
		imageView.setScaleType(ImageView.ScaleType.FIT_CENTER);
		setContentView(imageView);

		Log.v(LOG_TAG, "onCreate() : Bye");
	}

	private Bitmap createCirclesBitmap()
	{
		Bitmap bitmap = Bitmap.createBitmap(IMAGE_WIDTH, IMAGE_HEIGHT, Bitmap.Config.ARGB_8888);
		Canvas canvas = new Canvas(bitmap);
		Random random = new Random(0);

		// clear white
		canvas.drawARGB(0xff, 0xff, 0xff, 0xff);

		// draw circles
		Paint paint = new Paint();
		paint.setAntiAlias(true);
		for (int i = 0; i < 100; i++)
		{
			int a = random.nextInt(128) + 64;
			int r = random.nextInt(256);
			int g = random.nextInt(256);
			int b = random.nextInt(256);
			float cx = random.nextFloat() * canvas.getWidth();
			float cy = random.nextFloat() * canvas.getHeight();
			float radius = random.nextFloat() * (canvas.getWidth() / 16) + (canvas.getWidth() / 64);
			paint.setARGB(a, r, g, b);
			canvas.drawCircle(cx, cy, radius, paint);
		}

		return bitmap;
	}
}
