/*
 * The MIT License
 *
 * Copyright 2014 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.service_and_sqlite;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

public class MainActivity extends Activity
{

	private ComponentName serviceComponentName;
	private CountDownDBOpenHelper dbOpenHelper;

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
		dbOpenHelper = new CountDownDBOpenHelper(this);

		Button startServiceButton = (Button) findViewById(R.id.start_service_button);
		startServiceButton.setOnClickListener(new OnClickListener()
		{
			public void onClick(View view)
			{
				Toast.makeText(getApplicationContext(), "Start Service!", Toast.LENGTH_SHORT).show();
				Intent intent = new Intent(MainActivity.this, CountDownService.class);
				serviceComponentName = startService(intent);
			}
		});

		Button stopServiceButton = (Button) findViewById(R.id.stop_service_button);
		stopServiceButton.setOnClickListener(new OnClickListener()
		{
			public void onClick(View view)
			{
				Toast.makeText(getApplicationContext(), "Stop Service!", Toast.LENGTH_SHORT).show();
				if (serviceComponentName != null)
				{
					Intent intent = new Intent();
					intent.setComponent(serviceComponentName);
					stopService(intent);
					serviceComponentName = null;
				}
			}
		});

		Button updateDataButton = (Button) findViewById(R.id.update_data_button);
		updateDataButton.setOnClickListener(new OnClickListener()
		{
			public void onClick(View view)
			{
				updateDataTextView();
			}
		});

		Button clearDataButton = (Button) findViewById(R.id.clear_data_button);
		clearDataButton.setOnClickListener(new OnClickListener()
		{
			public void onClick(View view)
			{
				Toast.makeText(getApplicationContext(), "Clear Count Down Database!", Toast.LENGTH_SHORT).show();
				clearDataAndUpdateView();
			}
		});
	}

	private void clearDataAndUpdateView()
	{
		clearData();
		updateDataTextView();
	}

	private void clearData()
	{
		SQLiteDatabase db = dbOpenHelper.getReadableDatabase();
		try
		{
			db.execSQL("delete from " + CountDownDBOpenHelper.TABLE_NAME);
		}
		finally
		{
			db.close();
		}
	}

	private void updateDataTextView()
	{
		StringBuilder buffer = new StringBuilder();
		SQLiteDatabase db = dbOpenHelper.getReadableDatabase();
		try
		{
			String[] columns =
			{
				"id", "datetime", "count",
			};
			Cursor c = db.query(CountDownDBOpenHelper.TABLE_NAME, columns, null, null, null, null, null);
			if (c.moveToFirst())
			{
				do
				{
					int id = c.getInt(0);
					String datetime = c.getString(1);
					int count = c.getInt(2);
					buffer.append("--- id : ");
					buffer.append(id);
					buffer.append('\n');
					buffer.append("datetime : ");
					buffer.append(datetime);
					buffer.append('\n');
					buffer.append("count : ");
					buffer.append(count);
					buffer.append('\n');
				}
				while (c.moveToNext());
			}
		}
		finally
		{
			db.close();
		}

		TextView dataTextView = (TextView) findViewById(R.id.data_textview);
		dataTextView.setText(buffer);
	}
}
